/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.geso.mech.JsonValidator;
import me.geso.mech.JsonValidatorViolationException;
import me.geso.mech.MechRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;

public class MechResponse
implements Closeable {
    private final CloseableHttpResponse response;
    private byte[] content;
    private final MechRequest request;
    private final CloseableHttpClient httpClient;
    private final Optional<JsonValidator> jsonValidator;

    public MechResponse(MechRequest request, CloseableHttpClient httpClient, CloseableHttpResponse response, @NonNull Optional<JsonValidator> jsonValidator) {
        if (jsonValidator == null) {
            throw new NullPointerException("jsonValidator");
        }
        this.request = request;
        this.httpClient = httpClient;
        this.response = response;
        this.jsonValidator = jsonValidator;
    }

    public int getStatusCode() {
        return this.getResponse().getStatusLine().getStatusCode();
    }

    public Optional<String> getFirstHeader(String name) {
        Header firstHeader = this.getResponse().getFirstHeader(name);
        if (firstHeader != null) {
            return Optional.of(firstHeader.getValue());
        }
        return Optional.empty();
    }

    public List<String> getHeaders(String name) {
        return Arrays.stream(this.getResponse().getHeaders(name)).map(header -> header.getValue()).collect(Collectors.toList());
    }

    public ContentType getContentType() {
        ContentType contentType = ContentType.getOrDefault((HttpEntity)this.response.getEntity());
        return contentType;
    }

    public String getContentString() {
        ContentType contentType = ContentType.getOrDefault((HttpEntity)this.response.getEntity());
        return new String(this.getContent(), contentType.getCharset());
    }

    @JsonIgnore
    public String getContentString(Charset charset) {
        return new String(this.getContent(), charset);
    }

    public <T> T readJSON(Class<T> valueType) throws JsonParseException, JsonMappingException, IOException, JsonValidatorViolationException {
        Optional<String> errorMessage;
        ObjectMapper mapper = new ObjectMapper();
        Object data = mapper.readValue(this.getContent(), valueType);
        if (this.jsonValidator.isPresent() && (errorMessage = this.jsonValidator.get().validate(data)).isPresent()) {
            throw new JsonValidatorViolationException(errorMessage.get());
        }
        return (T)data;
    }

    public <T> T readJSON(TypeReference<T> valueTypeRef) throws JsonParseException, JsonMappingException, IOException, JsonValidatorViolationException {
        Optional<String> errorMessage;
        ObjectMapper mapper = new ObjectMapper();
        Object data = mapper.readValue(this.getContent(), valueTypeRef);
        if (this.jsonValidator.isPresent() && (errorMessage = this.jsonValidator.get().validate(data)).isPresent()) {
            throw new JsonValidatorViolationException(errorMessage.get());
        }
        return (T)data;
    }

    @JsonIgnore
    public HttpResponse getResponse() {
        return this.response;
    }

    public byte[] getContent() {
        if (this.content == null) {
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.response.getEntity().writeTo((OutputStream)stream);
                this.content = stream.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return Arrays.copyOf(this.content, this.content.length);
    }

    public MechRequest getRequest() {
        return this.request;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
        if (this.response != null) {
            this.response.close();
        }
    }
}

