/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.PrintStream;
import me.geso.mech.MechRequestListener;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class PrintRequestListener
implements MechRequestListener {
    private final PrintStream out;
    private boolean jsonPrettyPrintFilterEnabled;

    public PrintRequestListener() {
        this(System.out);
    }

    public PrintRequestListener(PrintStream out) {
        this.out = out;
    }

    public PrintRequestListener enableJsonPrettyPrintFilter() {
        this.jsonPrettyPrintFilterEnabled = true;
        return this;
    }

    @Override
    public void call(HttpRequest req, HttpResponse res) {
        try {
            Header contentType;
            Object[] bytes;
            this.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> REQUEST");
            this.out.println(req.getRequestLine().toString());
            for (Object header : req.getAllHeaders()) {
                this.out.println(header);
            }
            if (req instanceof HttpEntityEnclosingRequest) {
                this.out.println("");
                bytes = EntityUtils.toByteArray((HttpEntity)((HttpEntityEnclosingRequest)req).getEntity());
                this.out.write((byte[])bytes);
            }
            this.out.println("");
            this.out.println("");
            this.out.println("RESPONSE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
            this.out.println(res.getStatusLine());
            bytes = res.getAllHeaders();
            int n = bytes.length;
            for (int i = 0; i < n; ++i) {
                Object header;
                header = bytes[i];
                this.out.println(header);
            }
            this.out.println("");
            HttpEntity entity = res.getEntity();
            byte[] bytes2 = EntityUtils.toByteArray((HttpEntity)entity);
            if (this.jsonPrettyPrintFilterEnabled && (contentType = res.getFirstHeader("Content-Type")) != null && contentType.getValue().startsWith("application/json")) {
                ObjectMapper mapper = new ObjectMapper();
                mapper.enable(SerializationFeature.INDENT_OUTPUT);
                JsonNode tree = mapper.readTree(bytes2);
                bytes2 = mapper.writeValueAsBytes((Object)tree);
            }
            this.out.write(bytes2);
            this.out.println("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

