/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech2;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import me.geso.mech2.Mech2FailException;
import me.geso.mech2.Mech2Result;

public abstract class Mech2JSONResult<T> {
    private final Mech2Result result;

    private Mech2JSONResult(Mech2Result result) {
        this.result = result;
    }

    public static <T> Mech2JSONResult<T> of(Mech2Result result, TypeReference<T> klass) {
        return new Mech2JSONResultTypeReference<T>(result, klass);
    }

    public static <T> Mech2JSONResult<T> of(Mech2Result result, Class<T> klass) {
        return new Mech2JSONResultClass<T>(result, klass);
    }

    public Mech2Result getResult() {
        return this.result;
    }

    public Mech2JSONResult<T> orDie() throws Mech2FailException {
        if (this.result.isSuccess()) {
            return this;
        }
        throw new Mech2FailException(this.result);
    }

    public boolean isSuccess() {
        return this.result.isSuccess();
    }

    public abstract T parseJSON() throws IOException;

    public static class Mech2JSONResultTypeReference<T>
    extends Mech2JSONResult<T> {
        private final TypeReference<T> typeRef;

        public Mech2JSONResultTypeReference(Mech2Result result, TypeReference<T> typeRef) {
            super(result);
            this.typeRef = typeRef;
        }

        @Override
        public T parseJSON() throws IOException {
            return this.getResult().parseJSON(this.typeRef);
        }

        public String toString() {
            return "Mech2JSONResult.Mech2JSONResultTypeReference(typeRef=" + this.typeRef + ")";
        }
    }

    public static class Mech2JSONResultClass<T>
    extends Mech2JSONResult<T> {
        private final Class<T> klass;

        public Mech2JSONResultClass(Mech2Result result, Class<T> klass) {
            super(result);
            this.klass = klass;
        }

        @Override
        public T parseJSON() throws IOException {
            return this.getResult().parseJSON(this.klass);
        }

        public String toString() {
            return "Mech2JSONResult.Mech2JSONResultClass(klass=" + this.klass + ")";
        }
    }
}

