/*
 * Decompiled with CFR 0.152.
 */
package me.geso.mech2;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import me.geso.mech2.Mech2Request;
import me.geso.mech2.Mech2Result;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mech2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(Mech2.class);
    private final HttpClientBuilder httpClientBuilder;
    private final ObjectMapper objectMapper;

    private Mech2(HttpClientBuilder clientBuilder, ObjectMapper objectMapper) {
        this.httpClientBuilder = clientBuilder;
        this.objectMapper = objectMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Mech2Request get(URI uri) {
        return new Mech2Request(this, new URIBuilder(uri), (HttpRequestBase)new HttpGet());
    }

    public Mech2Request post(URI uri) {
        return new Mech2Request(this, new URIBuilder(uri), (HttpRequestBase)new HttpPost());
    }

    public Mech2Request put(URI uri) {
        return new Mech2Request(this, new URIBuilder(uri), (HttpRequestBase)new HttpPut());
    }

    public Mech2Request delete(URI uri) {
        return new Mech2Request(this, new URIBuilder(uri), (HttpRequestBase)new HttpDelete());
    }

    public Mech2Request head(URI uri) {
        return new Mech2Request(this, new URIBuilder(uri), (HttpRequestBase)new HttpHead());
    }

    public Mech2 disableRedirectHandling() {
        this.httpClientBuilder.disableRedirectHandling();
        return this;
    }

    public Mech2Result request(HttpUriRequest request) throws IOException {
        long startedOn = System.currentTimeMillis();
        try (CloseableHttpClient client = this.httpClientBuilder.build();){
            Mech2Result mech2Result;
            block12: {
                CloseableHttpResponse resp = client.execute(request);
                try {
                    LOGGER.info("{}: {}, {} secs", new Object[]{request.getURI(), resp.getStatusLine().toString(), (double)(System.currentTimeMillis() - startedOn) / 1000.0});
                    mech2Result = new Mech2Result((HttpRequest)request, (HttpResponse)resp, this);
                    if (resp == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resp.close();
            }
            return mech2Result;
        }
    }

    public HttpClientBuilder getHttpClientBuilder() {
        return this.httpClientBuilder;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public static class Builder {
        private HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        private ObjectMapper objectMapper = new ObjectMapper();

        private Builder() {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        public Builder setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.httpClientBuilder.setUserAgent(userAgent);
            return this;
        }

        public Mech2 build() {
            return new Mech2(this.httpClientBuilder, this.objectMapper);
        }
    }
}

