/*
 * Decompiled with CFR 0.152.
 */
package me.geso.routes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PathRoute<T> {
    private final String path;
    private final Pattern pattern;
    private final T destination;
    private final List<String> namedGroups = new ArrayList<String>();
    private static String starKey = "SSSstarSSS";
    private static String braceNormalPatternRe = "\\{(?<braceName>[a-zA-Z_][a-zA-Z0-9_-]*)\\}";
    private static String starPatternRe = "\\*";
    private static String namedRegexMatcherPatternRe = "\\{(?<regexName>[^:]+?):(?<regex>.+?)\\}(?<delimiter>/|$)";
    private static String escapePatternRe = "[\\-{}\\[\\]+?\\.,\\\\\\^$|#\\s]";
    private static Pattern matchPattern = Pattern.compile(String.format("(%s)|(%s)|(%s)|(%s)", braceNormalPatternRe, starPatternRe, namedRegexMatcherPatternRe, escapePatternRe));

    PathRoute(String path, T destination) {
        this.path = path;
        this.pattern = Pattern.compile(this.compileToRegexp(path));
        this.destination = destination;
    }

    String compileToRegexp(String path) {
        Matcher m = matchPattern.matcher(path);
        StringBuffer sb = new StringBuffer(path.length());
        while (m.find()) {
            String replace;
            if (m.group(1) != null) {
                this.namedGroups.add(m.group("braceName"));
                replace = "(?<" + m.group("braceName") + ">[a-zA-Z0-9._-]+)";
                m.appendReplacement(sb, replace);
                continue;
            }
            if (m.group(3) != null) {
                this.namedGroups.add(starKey);
                replace = String.format("(?<%s>.+)", starKey);
                m.appendReplacement(sb, replace);
                continue;
            }
            if (m.group(4) != null) {
                this.namedGroups.add(m.group("regexName"));
                String delimiter = m.group("delimiter").equals("/") ? "/" : "";
                m.appendReplacement(sb, "(?<" + m.group("regexName") + ">" + m.group("regex") + ")" + delimiter);
                continue;
            }
            if (m.group(8) != null) {
                replace = "\\\\" + m.group(8);
                m.appendReplacement(sb, replace);
                continue;
            }
            throw new RuntimeException();
        }
        m.appendTail(sb);
        return sb.toString();
    }

    boolean match(String path, Map<String, String> captured) {
        Matcher m = this.pattern.matcher(path);
        if (m.matches()) {
            for (String name : this.namedGroups) {
                String key = name.equals(starKey) ? "*" : name;
                captured.put(key, m.group(name));
            }
            return true;
        }
        return false;
    }

    T getDestination() {
        return this.destination;
    }

    String getPath() {
        return this.path;
    }
}

