/*
 * Decompiled with CFR 0.152.
 */
package me.ghui.fruit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.ghui.fruit.PickAdapter;
import me.ghui.fruit.PickAdapterFactory;
import me.ghui.fruit.bind.PickAdapters;
import me.ghui.fruit.internal.Preconditions;
import me.ghui.fruit.reflect.TypeToken;
import org.jsoup.Jsoup;
import org.jsoup.helper.DataUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class Fruit {
    private static final TypeToken<?> NULL_KEY_SURROGATE = new TypeToken<Object>(){};
    private final Map<TypeToken<?>, PickAdapter<?>> mTypeTokenCache = new ConcurrentHashMap();
    private final List<PickAdapterFactory> mFactories;

    public Fruit() {
        ArrayList<PickAdapterFactory> factories = new ArrayList<PickAdapterFactory>();
        factories.add(PickAdapters.INTEGER_FACTORY);
        factories.add(PickAdapters.LONG_FACTORY);
        factories.add(PickAdapters.STRING_FACTORY);
        factories.add(PickAdapters.COLLECTION_FACTORY);
        factories.add(PickAdapters.REFLECTIVE_ADAPTER);
        this.mFactories = Collections.unmodifiableList(factories);
    }

    public <T> T fromHtml(String html, Class<T> classOfT) {
        return this.fromHtml(html, (Type)classOfT);
    }

    public <T> T fromHtml(String html, Type typeOfT) {
        if (Preconditions.isEmpty(html)) {
            return null;
        }
        return this.fromHtml((Element)Jsoup.parse((String)html), typeOfT);
    }

    public <T> T fromHtml(File file, String charsetName, String baseUri, Class<T> classOfT) throws IOException {
        Document element = DataUtil.load((File)file, (String)charsetName, (String)baseUri);
        return this.fromHtml((Element)element, classOfT);
    }

    public <T> T fromHtml(Element element, Type typeOfT) {
        TypeToken<?> typeToken = TypeToken.get(typeOfT);
        PickAdapter<?> pickAdapter = this.getAdapter(typeToken);
        return (T)pickAdapter.read(element, null);
    }

    public <T> PickAdapter<T> getAdapter(Class<T> type) {
        return this.getAdapter(TypeToken.get(type));
    }

    public <T> PickAdapter<T> getAdapter(TypeToken<T> type) {
        PickAdapter<?> cached = this.mTypeTokenCache.get(type == null ? NULL_KEY_SURROGATE : type);
        if (cached != null) {
            return cached;
        }
        for (PickAdapterFactory factory : this.mFactories) {
            PickAdapter<T> pickAdapter = factory.create(this, type);
            if (pickAdapter == null) continue;
            this.mTypeTokenCache.put(type, pickAdapter);
            return pickAdapter;
        }
        throw new IllegalArgumentException("Fruit cannot handle " + type + " for now");
    }
}

