/*
 * Decompiled with CFR 0.152.
 */
package me.ghui.fruit.bind;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import me.ghui.fruit.Fruit;
import me.ghui.fruit.PickAdapter;
import me.ghui.fruit.PickAdapterFactory;
import me.ghui.fruit.annotations.Nullable;
import me.ghui.fruit.annotations.Pick;
import me.ghui.fruit.internal.Types;
import me.ghui.fruit.reflect.TypeToken;
import org.jsoup.nodes.Element;

public final class ReflectivePickAdapterFactory
implements PickAdapterFactory {
    @Override
    public <T> PickAdapter<T> create(Fruit fruit, TypeToken<T> type) {
        Class<T> raw = type.getRawType();
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        return new Adapter<T>(type, this.getBoundFields(fruit, type, raw));
    }

    private List<BoundField> getBoundFields(Fruit fruit, TypeToken<?> type, Class<?> raw) {
        ArrayList<BoundField> boundFields = new ArrayList<BoundField>();
        if (raw.isInterface()) {
            return boundFields;
        }
        while (raw != Object.class) {
            for (Field field : raw.getDeclaredFields()) {
                String name;
                if (field.getAnnotation(Pick.class) == null || (name = field.getName()).contains("$change") || name.equals("serialVersionUID") || field.isSynthetic()) continue;
                field.setAccessible(true);
                Type fieldType = Types.resolve(type.getType(), raw, field.getGenericType());
                BoundField boundField = this.createBoundField(fruit, field, TypeToken.get(fieldType));
                boundFields.add(boundField);
            }
            type = TypeToken.get(Types.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return boundFields;
    }

    private BoundField createBoundField(Fruit fruit, Field field, TypeToken<?> fieldType) {
        final PickAdapter<?> pickAdapter = fruit.getAdapter(fieldType);
        return new BoundField(field){

            @Override
            public void read(Element element, Object instance) throws IllegalAccessException {
                Pick pick = this.field.getAnnotation(Pick.class);
                if (pick == null) {
                    System.out.println("ignore Field: " + this.field.getName() + " without a Pick anotation");
                    return;
                }
                Object fieldValue = pickAdapter.read(element, pick);
                if (fieldValue != null) {
                    this.field.set(instance, fieldValue);
                }
            }
        };
    }

    private static abstract class BoundField {
        Field field;

        BoundField(Field field) {
            this.field = field;
        }

        public abstract void read(Element var1, Object var2) throws IllegalAccessException;
    }

    private static final class Adapter<T>
    extends PickAdapter<T> {
        private TypeToken<T> type;
        private List<BoundField> boundFields;

        Adapter(TypeToken<T> type, List<BoundField> boundFields) {
            this.type = type;
            this.boundFields = boundFields;
        }

        @Override
        public T read(Element element, @Nullable Pick pick) {
            Pick classPick;
            if (pick != null) {
                element = element.select(pick.value()).first();
            }
            if ((classPick = this.type.getRawType().getAnnotation(Pick.class)) != null) {
                element = element.select(classPick.value()).first();
            }
            T instance = null;
            if (element == null) {
                return instance;
            }
            try {
                Constructor<T> constructor = this.type.getRawType().getDeclaredConstructor(new Class[0]);
                if (!constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                instance = constructor.newInstance(new Object[0]);
                for (BoundField boundField : this.boundFields) {
                    boundField.read(element, instance);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
            return instance;
        }
    }
}

