/*
 * Decompiled with CFR 0.152.
 */
package me.gilbva.shrike.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.gilbva.shrike.annotations.ComponentInit;
import me.gilbva.shrike.annotations.Inject;
import me.gilbva.shrike.annotations.InjectNext;

class ClassCache {
    private final List<Field> injectFields;
    private final Constructor constructor;
    private final List<Method> postConstructs;

    ClassCache(Class<?> cls) {
        this.injectFields = this.createInjectFields(cls);
        this.constructor = this.findConstructor(cls);
        this.postConstructs = this.findPostConstructs(cls);
    }

    List<Field> getInjectFields() {
        return this.injectFields;
    }

    Constructor getConstructor() {
        return this.constructor;
    }

    List<Method> getPostConstructs() {
        return this.postConstructs;
    }

    private List<Field> createInjectFields(Class<?> cls) {
        Field[] declaredFields;
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : declaredFields = cls.getDeclaredFields()) {
            Inject annotation = field.getAnnotation(Inject.class);
            InjectNext annotationNext = field.getAnnotation(InjectNext.class);
            if (annotation != null) {
                field.trySetAccessible();
                result.add(field);
                continue;
            }
            if (annotationNext == null) continue;
            field.trySetAccessible();
            result.add(field);
        }
        return result;
    }

    private Constructor findConstructor(Class<?> cls) {
        for (Constructor<?> cons : cls.getDeclaredConstructors()) {
            if (cons.getParameterTypes().length != 0) continue;
            cons.trySetAccessible();
            return cons;
        }
        return null;
    }

    private List<Method> findPostConstructs(Class<?> cls) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : methods = cls.getDeclaredMethods()) {
            ComponentInit annotation = method.getAnnotation(ComponentInit.class);
            if (annotation == null) continue;
            method.trySetAccessible();
            result.add(method);
        }
        return result;
    }
}

