/*
 * Decompiled with CFR 0.152.
 */
package me.gilbva.shrike.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.gilbva.shrike.container.ClassSetLoader;
import me.gilbva.shrike.container.ClassUtils;
import me.gilbva.shrike.navigation.ClassNavigator;
import me.gilbva.shrike.navigation.ClassRepository;
import me.gilbva.shrike.navigation.FieldNavigator;
import me.gilbva.shrike.navigation.MethodNavigator;

class ClassSet
implements Iterable<Class<?>>,
ClassRepository {
    private final Set<Class<?>> clsSet = new HashSet();
    private final List<Class<?>> sortedClasses = new ArrayList();

    private ClassSet() {
    }

    ClassSet(Collection<Class<?>> classes) {
        this();
        if (classes != null && !classes.isEmpty()) {
            this.clsSet.addAll(classes);
            this.sortedClasses.addAll(this.clsSet);
            ClassUtils.sort(this.sortedClasses);
        }
    }

    public ClassSet(Class<?> ... classes) {
        this(ClassSet.asList(classes));
    }

    public ClassSet(ClassSet ... lsts) {
        this();
        if (lsts != null && lsts.length > 0) {
            for (ClassSet clst : lsts) {
                if (clst == null || clst.isEmpty()) continue;
                this.clsSet.addAll(clst.clsSet);
            }
        }
        this.sortedClasses.addAll(this.clsSet);
        ClassUtils.sort(this.sortedClasses);
    }

    boolean contains(Class cls) {
        return this.clsSet.contains(cls);
    }

    boolean isEmpty() {
        return this.clsSet.isEmpty();
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.sortedClasses.iterator();
    }

    static ClassSet findByScope(Class<?> scope) {
        return ClassSetLoader.instance().findByScope(scope);
    }

    public int size() {
        return this.clsSet.size();
    }

    private static Collection<Class<?>> asList(Class<?> ... clss) {
        if (clss == null || clss.length == 0) {
            return null;
        }
        return Arrays.asList(clss);
    }

    @Override
    public <A extends Annotation> void forEachMethod(Class<A> annotation, MethodNavigator<A> navigator) {
        for (Class<?> cls : this) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                A annInst = method.getAnnotation(annotation);
                if (annInst == null) continue;
                navigator.accept(method, cls, annInst);
            }
        }
    }

    @Override
    public <A extends Annotation> void forEachField(Class<A> annotation, FieldNavigator<A> navigator) {
        for (Class<?> cls : this) {
            Field[] fields;
            for (Field field : fields = cls.getDeclaredFields()) {
                A annInst = field.getAnnotation(annotation);
                if (annInst == null) continue;
                navigator.accept(field, cls, annInst);
            }
        }
    }

    @Override
    public <A extends Annotation> void forEachClass(Class<A> annotation, ClassNavigator<A, Object> navigator) {
        for (Class<?> cls : this) {
            A annot = cls.getAnnotation(annotation);
            if (annot == null) continue;
            navigator.accept(cls, annot);
        }
    }

    @Override
    public <A extends Annotation, T> void forEachClass(Class<A> annotation, Class<T> service, ClassNavigator<A, T> navigator) {
        for (Class<?> cls : this) {
            A annot = cls.getAnnotation(annotation);
            if (annot == null || !service.isAssignableFrom(cls)) continue;
            navigator.accept(cls, annot);
        }
    }
}

