/*
 * Decompiled with CFR 0.152.
 */
package me.gilbva.shrike.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.gilbva.shrike.annotations.Priority;

public class ClassUtils {
    private static final String JAVA_PACKAGE_PREFIX = "java.";
    private static final Logger LOG = Logger.getLogger(ClassUtils.class.getName());

    static Type typeOf(WildcardType service) {
        Type[] upperBounds = service.getUpperBounds();
        if (upperBounds.length == 1) {
            return upperBounds[0];
        }
        if (upperBounds.length == 0) {
            return Object.class;
        }
        return null;
    }

    static Type multipleType(Type service) {
        if (ClassUtils.isArray(service)) {
            return ClassUtils.arrayType(service);
        }
        if (ClassUtils.isCollection(service)) {
            return ClassUtils.collectionType(service);
        }
        if (ClassUtils.isMap(service)) {
            return ClassUtils.mapType(service);
        }
        return null;
    }

    static Type arrayType(Type service) {
        if (service instanceof GenericArrayType) {
            Type rawType = ((GenericArrayType)service).getGenericComponentType();
            return rawType;
        }
        if (service instanceof Class) {
            return ((Class)service).getComponentType();
        }
        return null;
    }

    static Type collectionType(Type service) {
        Type[] args;
        if (service instanceof ParameterizedType && (args = ((ParameterizedType)service).getActualTypeArguments()).length == 1) {
            return args[0];
        }
        return null;
    }

    static Type mapType(Type service) {
        Type[] args;
        if (service instanceof ParameterizedType && (args = ((ParameterizedType)service).getActualTypeArguments()).length == 2) {
            return args[1];
        }
        return null;
    }

    public static Type parameterType(Type service, int index) {
        Type[] args;
        if (service instanceof ParameterizedType && index < (args = ((ParameterizedType)service).getActualTypeArguments()).length) {
            return args[index];
        }
        return null;
    }

    static boolean isMultiple(Type service) {
        return ClassUtils.isArray(service) || ClassUtils.isCollection(service) || ClassUtils.isMap(service);
    }

    static boolean isArray(Type service) {
        if (service instanceof Class) {
            return ((Class)service).isArray();
        }
        return service instanceof GenericArrayType;
    }

    static boolean isCollection(Type service) {
        Class cls = ClassUtils.rawClass(service);
        if (cls == null || cls.isArray() || cls.getPackage() == null) {
            return false;
        }
        return ClassUtils.isJavaPackage(cls.getPackage().getName()) && Collection.class.isAssignableFrom(cls) && !Map.class.isAssignableFrom(cls);
    }

    static boolean isMap(Type service) {
        Class cls = ClassUtils.rawClass(service);
        if (cls == null || cls.isArray() || cls.getPackage() == null) {
            return false;
        }
        return ClassUtils.isJavaPackage(cls.getPackage().getName()) && Map.class.isAssignableFrom(cls);
    }

    static Class rawClass(Type service) {
        if (service instanceof Class) {
            return (Class)service;
        }
        if (service instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)service).getRawType();
            if (rawType instanceof Class) {
                return (Class)rawType;
            }
        } else if (service instanceof WildcardType) {
            Type wildCardType = ClassUtils.typeOf((WildcardType)service);
            return ClassUtils.rawClass(wildCardType);
        }
        return null;
    }

    public static Collection<Class<?>> toClasses(Collection instances) {
        ArrayList arrList = new ArrayList();
        instances.forEach(i -> arrList.add(i.getClass()));
        return arrList;
    }

    static int findPriority(Class<?> cls) {
        Priority a1 = cls.getAnnotation(Priority.class);
        int v1 = Integer.MAX_VALUE;
        if (a1 != null) {
            v1 = a1.value();
        }
        return v1;
    }

    static Object createMultiple(Type service, Object[] data) {
        try {
            if (data != null) {
                if (ClassUtils.isCollection(service)) {
                    Class resultClass = ClassUtils.rawClass(service);
                    return ClassUtils.createCollection(resultClass, data);
                }
                if (ClassUtils.isMap(service)) {
                    Class resultClass = ClassUtils.rawClass(service);
                    return ClassUtils.createCollection(resultClass, data);
                }
                if (ClassUtils.isArray(service)) {
                    return data;
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return null;
    }

    static Collection createCollection(Class collectionCls, Object[] data) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        AbstractCollection res = null;
        Constructor construct = ClassUtils.findConstructor(collectionCls);
        if (construct != null && construct.trySetAccessible()) {
            res = (ArrayList<Object>)construct.newInstance(new Object[0]);
        } else if (collectionCls.isAssignableFrom(ArrayList.class)) {
            res = new ArrayList<Object>(data.length);
        } else if (collectionCls.isAssignableFrom(LinkedHashSet.class)) {
            res = new LinkedHashSet(data.length);
        } else if (collectionCls.isAssignableFrom(PriorityBlockingQueue.class)) {
            res = new PriorityBlockingQueue(data.length);
        }
        if (res != null) {
            res.addAll(Arrays.asList(data));
        }
        return res;
    }

    public static Map createMap(Class mapCls, Object[] data) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        LinkedHashMap map = null;
        Constructor construct = ClassUtils.findConstructor(mapCls);
        if (construct != null && construct.trySetAccessible()) {
            map = (LinkedHashMap)construct.newInstance(new Object[0]);
        } else if (mapCls.isAssignableFrom(LinkedHashMap.class)) {
            map = new LinkedHashMap(data.length);
        }
        if (map != null) {
            for (Object cmp : data) {
                map.put(cmp.getClass(), cmp);
            }
        }
        return map;
    }

    private static Constructor findConstructor(Class cls) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return constructor;
        }
        return null;
    }

    static void sort(List<Class<?>> value) {
        Collections.sort(value, (c1, c2) -> {
            int v1 = ClassUtils.findPriority(c1);
            int v2 = ClassUtils.findPriority(c2);
            return Integer.compare(v1, v2);
        });
    }

    static boolean hasGenericDeclaration(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] types;
            ParameterizedType pType = (ParameterizedType)type;
            for (Type t : types = pType.getActualTypeArguments()) {
                if (!ClassUtils.hasGenericDeclaration(t)) continue;
                return true;
            }
        }
        return type instanceof TypeVariable || type instanceof WildcardType;
    }

    private static boolean isJavaPackage(String name) {
        return name.startsWith(JAVA_PACKAGE_PREFIX);
    }
}

