/*
 * Decompiled with CFR 0.152.
 */
package me.gilbva.shrike.container;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.gilbva.shrike.annotations.Inject;
import me.gilbva.shrike.annotations.InjectNext;
import me.gilbva.shrike.container.ClassUtils;
import me.gilbva.shrike.container.ContextImpl;
import me.gilbva.shrike.container.ServiceMap;
import me.gilbva.shrike.context.IocContextListener;

class Instanciator {
    private static final Logger LOG = Logger.getLogger(Instanciator.class.getName());
    private final ContextImpl<?> context;
    private final ServiceMap serviceMap;
    private IocContextListener[] contextListeners;

    Instanciator(ContextImpl context, ServiceMap serviceMap) {
        this.context = context;
        this.serviceMap = serviceMap;
    }

    <T> T instantiate(Class<T> cls) {
        try {
            Constructor constructor = this.context.findCache(cls).getConstructor();
            if (constructor == null) {
                return null;
            }
            constructor.trySetAccessible();
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            LOG.warning(ex.getMessage());
            return null;
        }
    }

    void callPostConstruct(Class cls, Object obj) {
        Class currentClass = cls;
        while (!currentClass.equals(Object.class)) {
            List<Method> methods = this.context.findCache(currentClass).getPostConstructs();
            for (Method method : methods) {
                try {
                    method.invoke(obj, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    void injectDependencies(Class cls, Object obj) {
        List<Field> fields = this.context.findCache(cls).getInjectFields();
        for (Field field : fields) {
            InjectNext annotationNext;
            Inject annotation = field.getAnnotation(Inject.class);
            if (annotation != null) {
                this.injectDependency(cls, obj, field, null);
            }
            if ((annotationNext = field.getAnnotation(InjectNext.class)) == null) continue;
            this.injectDependency(cls, obj, field, ClassUtils.findPriority(cls));
        }
        Class supClass = cls.getSuperclass();
        if (supClass != null && supClass != Object.class) {
            this.injectDependencies(supClass, obj);
        }
    }

    private void injectDependency(Class cls, Object obj, Field field, Integer priority) {
        try {
            Type service = field.getGenericType();
            Object componentObj = priority == null ? this.context.findGeneric(service) : this.context.findNextGeneric(service, priority);
            field.set(obj, componentObj);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private void initContextListeners() {
        if (null == this.contextListeners) {
            this.contextListeners = this.context.findAll(IocContextListener.class);
        }
    }

    <T> void invokePreCreateListener(Class<T> cls) {
        if (IocContextListener.class.isAssignableFrom(cls)) {
            return;
        }
        this.initContextListeners();
        if (null != this.contextListeners) {
            block0: for (IocContextListener contextListener : this.contextListeners) {
                Type type = this.findGenericType(contextListener.getClass());
                if (type.equals(Object.class)) {
                    contextListener.preCreateComponent(cls);
                    continue;
                }
                List<Type> services = this.serviceMap.getServices(cls);
                if (services == null) continue;
                for (Type service : services) {
                    if (!type.equals(service)) continue;
                    contextListener.preCreateComponent(cls);
                    continue block0;
                }
            }
        }
    }

    <T> void invokePreInitListener(Class<T> cls, Object instance) {
        if (IocContextListener.class.isAssignableFrom(cls)) {
            return;
        }
        this.initContextListeners();
        if (null != this.contextListeners) {
            block0: for (IocContextListener contextListener : this.contextListeners) {
                Type type = this.findGenericType(contextListener.getClass());
                if (type.equals(Object.class)) {
                    contextListener.preInitComponent(cls, instance);
                    continue;
                }
                List<Type> services = this.serviceMap.getServices(cls);
                if (services == null) continue;
                for (Type service : services) {
                    if (!type.equals(service)) continue;
                    contextListener.preInitComponent(cls, instance);
                    continue block0;
                }
            }
        }
    }

    <T> void invokePostInitListener(Class<T> cls, Object instance) {
        if (IocContextListener.class.isAssignableFrom(cls)) {
            return;
        }
        this.initContextListeners();
        if (null != this.contextListeners) {
            block0: for (IocContextListener contextListener : this.contextListeners) {
                Type type = this.findGenericType(contextListener.getClass());
                if (type.equals(Object.class)) {
                    contextListener.postInitComponent(cls, instance);
                    continue;
                }
                List<Type> services = this.serviceMap.getServices(cls);
                if (services == null) continue;
                for (Type service : services) {
                    if (!type.equals(service)) continue;
                    contextListener.postInitComponent(cls, instance);
                    continue block0;
                }
            }
        }
    }

    private Type findGenericType(Class<? extends IocContextListener> clazz) {
        Type[] ifcs;
        for (Type ifc : ifcs = clazz.getGenericInterfaces()) {
            if (!(ifc instanceof ParameterizedType) || !ClassUtils.rawClass(ifc).equals(IocContextListener.class)) continue;
            return ((ParameterizedType)ifc).getActualTypeArguments()[0];
        }
        return Object.class;
    }
}

