/*
 * Decompiled with CFR 0.152.
 */
package me.gilbva.shrike.processor;

import java.io.IOException;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.type.MirroredTypeException;
import me.gilbva.shrike.annotations.Component;
import me.gilbva.shrike.utils.ClassListPropertyFile;

@SupportedAnnotationTypes(value={"me.gilbva.shrike.annotations.Component"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_15)
public class ComponentProcessor
extends ClassListPropertyFile {
    static final String COMPONENTS_RESOURCE_FILE = "META-INF/shrike/ioc-components.properties";

    @Override
    public String getFileName() {
        return COMPONENTS_RESOURCE_FILE;
    }

    @Override
    public void processElement(Element element) throws IOException {
        Component annot = element.getAnnotation(Component.class);
        String clsName = element.toString();
        String scope = this.findScope(annot);
        this.appendProperty(clsName, scope);
    }

    private String findScope(Component annot) {
        try {
            annot.scope();
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror().toString();
        }
        return "";
    }
}

