/*
 * Decompiled with CFR 0.152.
 */
package me.gilbva.shrike.utils;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class ClassListPropertyFile
extends AbstractProcessor {
    private Writer writer;
    private static final Logger LOG = Logger.getLogger(ClassListPropertyFile.class.getName());

    public abstract String getFileName();

    public abstract void processElement(Element var1) throws IOException;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Messager messager = processingEnv.getMessager();
        try {
            Filer filer = processingEnv.getFiler();
            FileObject fobj = filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.getFileName(), new Element[0]);
            this.writer = fobj.openWriter();
        }
        catch (IOException e) {
            messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            LOG.severe(e.getMessage());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Messager messager = this.processingEnv.getMessager();
        try {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> ann = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : ann) {
                    if (element.getKind() != ElementKind.CLASS) continue;
                    this.processElement(element);
                }
            }
        }
        catch (IOException ex) {
            messager.printMessage(Diagnostic.Kind.ERROR, ex.getMessage());
            LOG.severe(ex.getMessage());
        }
        return true;
    }

    protected void appendProperty(String key, String value) throws IOException {
        this.writer.append(key);
        this.writer.append("=");
        this.writer.append(value);
        this.writer.append('\n');
        this.writer.flush();
    }
}

