/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.SSHEnvironment;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHEnvironmentFactory.class);
    private static final String XML_ENV_HOSTS_FIELD = "hosts";
    private static final String XML_ENV_USERNAME_FIELD = "username";
    private static final String XML_ENV_PRIVATE_KEY_FIELD = "private-key";
    private static final String XML_ENV_DIR_FIELD = "remote-dir";
    private static final String DEFAULT_REMOTE_DIR = "";
    private final Configuration mConfig;
    private final Executor mExecutor;

    public SSHEnvironmentFactory(Configuration config) {
        this.mConfig = config;
        this.mExecutor = Executors.newFixedThreadPool(100);
    }

    @Override
    public Collection<Environment> createEnvironments() throws IOException {
        LOGGER.info("createEnvironments()");
        List hosts = this.mConfig.getList(XML_ENV_HOSTS_FIELD);
        if (null == hosts || hosts.isEmpty()) {
            throw new IllegalArgumentException("Hosts field does not exist or is empty.");
        }
        String username = this.mConfig.getString(XML_ENV_USERNAME_FIELD);
        String privateKeyString = this.mConfig.getString(XML_ENV_PRIVATE_KEY_FIELD);
        Path privateKeyPath = FileSystems.getDefault().getPath(privateKeyString, new String[0]);
        String remoteDir = this.mConfig.getString(XML_ENV_DIR_FIELD, DEFAULT_REMOTE_DIR);
        LinkedList<Environment> environments = new LinkedList<Environment>();
        for (int envIdx = 0; envIdx < hosts.size(); ++envIdx) {
            LOGGER.trace("createEnvironments(): Setting up environment for host: {}.", (Object)hosts.get(envIdx).toString());
            SSHEnvironment env = new SSHEnvironment(envIdx, username, privateKeyPath, InetAddress.getByName(hosts.get(envIdx).toString()), remoteDir, this.mExecutor);
            environments.add(env);
        }
        return environments;
    }

    @Override
    public void destroyEnvironments(Collection<Environment> envs) {
        LOGGER.info("destroyEnvironments()");
    }
}

