/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import me.gregorias.dfuntest.AbstractConfigurationEnvironment;
import me.gregorias.dfuntest.RemoteProcess;
import org.apache.commons.io.FileUtils;

public class LocalEnvironment
extends AbstractConfigurationEnvironment {
    private final int mId;
    private final Path mDir;

    public LocalEnvironment(int id, Path dir) {
        this.mId = id;
        this.mDir = dir;
    }

    @Override
    public void copyFilesFromLocalDisk(Path srcPath, String destRelPath) throws IOException {
        Path destPath = this.mDir.resolve(destRelPath);
        if (!Files.exists(destPath, new LinkOption[0])) {
            Files.createDirectories(destPath, new FileAttribute[0]);
        } else if (!Files.isDirectory(destPath, new LinkOption[0])) {
            throw new IOException("Destination path exists and it is not a directory.");
        }
        if (Files.isDirectory(srcPath, new LinkOption[0])) {
            FileUtils.copyDirectoryToDirectory((File)srcPath.toFile(), (File)destPath.toFile());
        } else {
            FileUtils.copyFileToDirectory((File)srcPath.toFile(), (File)destPath.toFile());
        }
    }

    @Override
    public void copyFilesToLocalDisk(String srcRelPath, Path destPath) throws IOException {
        Path srcPath = this.mDir.resolve(srcRelPath);
        if (!Files.exists(destPath, new LinkOption[0])) {
            Files.createDirectories(destPath, new FileAttribute[0]);
        } else if (!Files.isDirectory(destPath, new LinkOption[0])) {
            throw new IOException("Destination path exists and it is not a directory.");
        }
        if (Files.isDirectory(srcPath, new LinkOption[0])) {
            FileUtils.copyDirectoryToDirectory((File)srcPath.toFile(), (File)destPath.toFile());
        } else {
            FileUtils.copyFileToDirectory((File)srcPath.toFile(), (File)destPath.toFile());
        }
    }

    @Override
    public String getHostname() {
        return "localhost";
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mDir.toAbsolutePath().toString();
    }

    @Override
    public RemoteProcess runCommand(List<String> command) throws InterruptedException, IOException {
        RemoteProcess process = this.runCommandAsynchronously(command);
        process.waitFor();
        return process;
    }

    @Override
    public RemoteProcess runCommandAsynchronously(List<String> command) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command);
        pb.directory(this.mDir.toFile());
        Process process = pb.start();
        return new ProcessAdapter(process);
    }

    @Override
    public void removeFile(String relPath) {
        FileUtils.deleteQuietly((File)this.mDir.resolve(relPath).toFile());
    }

    private static class ProcessAdapter
    implements RemoteProcess {
        private final Process mProcess;

        public ProcessAdapter(Process process) {
            this.mProcess = process;
        }

        @Override
        public void destroy() {
            this.mProcess.destroy();
        }

        @Override
        public InputStream getErrorStream() {
            return this.mProcess.getErrorStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.mProcess.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.mProcess.getOutputStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.mProcess.waitFor();
        }
    }
}

