/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.LocalEnvironment;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvironmentFactory
implements EnvironmentFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalEnvironmentFactory.class);
    private static final String XML_ENV_CNT_FIELD = "environment-count";
    private static final String XML_ENV_DIR_FIELD = "dir-prefix";
    private static final String ENV_CONFIG_ROOT_DIR = "root-dir";
    private static final String DEFAULT_DIR_PREFIX = "dfuntest";
    private final Configuration mConfig;

    public LocalEnvironmentFactory(Configuration config) {
        this.mConfig = config;
    }

    @Override
    public Collection<Environment> createEnvironments() throws IOException {
        LOGGER.info("createEnvironments()");
        int count = this.mConfig.getInteger(XML_ENV_CNT_FIELD, Integer.valueOf(0));
        if (count <= 0) {
            throw new IllegalArgumentException("Number of environments has not been provided or was invalid.");
        }
        String dirPrefix = this.mConfig.getString(XML_ENV_DIR_FIELD, DEFAULT_DIR_PREFIX);
        LinkedList<Environment> environments = new LinkedList<Environment>();
        for (int envIdx = 0; envIdx < count; ++envIdx) {
            Path tempDirPath = Files.createTempDirectory(dirPrefix, new FileAttribute[0]);
            LocalEnvironment env = new LocalEnvironment(envIdx, tempDirPath);
            env.setProperty(ENV_CONFIG_ROOT_DIR, tempDirPath);
            environments.add(env);
        }
        return environments;
    }

    @Override
    public void destroyEnvironments(Collection<Environment> envs) {
        LOGGER.info("destroyEnvironments()");
        for (Environment env : envs) {
            Path dirPath;
            try {
                dirPath = (Path)env.getProperty(ENV_CONFIG_ROOT_DIR);
            }
            catch (ClassCastException | NoSuchElementException e) {
                LOGGER.error("Could not destroy environment.", (Throwable)e);
                continue;
            }
            FileUtils.deleteQuietly((File)dirPath.toFile());
        }
    }
}

