/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import me.gregorias.dfuntest.App;
import me.gregorias.dfuntest.ApplicationFactory;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.EnvironmentPreparator;
import me.gregorias.dfuntest.TestResult;
import me.gregorias.dfuntest.TestRunner;
import me.gregorias.dfuntest.TestScript;
import org.slf4j.Logger;

public class SingleTestRunner<TestedAppT extends App>
implements TestRunner {
    private final Logger mLogger;
    private final TestScript<TestedAppT> mScript;
    private final EnvironmentFactory mEnvironmentFactory;
    private final EnvironmentPreparator mEnvironmentPreparator;
    private final ApplicationFactory<TestedAppT> mApplicationFactory;

    public SingleTestRunner(TestScript<TestedAppT> script, Logger logger, EnvironmentFactory environmentFactory, EnvironmentPreparator environmentPreparator, ApplicationFactory<TestedAppT> applicationFactory) {
        this.mScript = script;
        this.mLogger = logger;
        this.mEnvironmentFactory = environmentFactory;
        this.mEnvironmentPreparator = environmentPreparator;
        this.mApplicationFactory = applicationFactory;
    }

    @Override
    public TestResult run() {
        Collection<Environment> envs;
        this.mLogger.info("run(): Starting preparation for test script {}.", (Object)this.mScript.toString());
        this.mLogger.info("run(): Creating environments.");
        try {
            envs = this.mEnvironmentFactory.createEnvironments();
        }
        catch (IOException e) {
            this.mLogger.error("run(): Could not create environments.", (Throwable)e);
            return new TestResult(TestResult.Type.FAILURE, "Could not create environments.");
        }
        try {
            this.mLogger.info("run(): Preparing environments.");
            this.mEnvironmentPreparator.prepareEnvironments(envs);
            this.mLogger.info("run(): Environments prepared: ", (Object)envs.size());
        }
        catch (ExecutionException e) {
            this.mLogger.error("run(): Could not prepare environments.", (Throwable)e);
            this.mEnvironmentFactory.destroyEnvironments(envs);
            return new TestResult(TestResult.Type.FAILURE, "Could not prepare environments.");
        }
        LinkedList<TestedAppT> apps = new LinkedList<TestedAppT>();
        for (Environment env : envs) {
            apps.add(this.mApplicationFactory.newApp(env));
        }
        TestResult result = this.mScript.run(apps);
        this.mLogger.info("run(): Collecting output and log files.");
        this.mEnvironmentPreparator.collectOutputAndLogFiles(envs);
        this.mEnvironmentPreparator.cleanEnvironments(envs);
        this.mEnvironmentFactory.destroyEnvironments(envs);
        return result;
    }
}

