/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import me.gregorias.dfuntest.App;
import me.gregorias.dfuntest.ApplicationFactory;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.EnvironmentPreparator;
import me.gregorias.dfuntest.TestResult;
import me.gregorias.dfuntest.TestRunner;
import me.gregorias.dfuntest.TestScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTestRunner<EnvironmentT extends Environment, AppT extends App<EnvironmentT>>
implements TestRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleTestRunner.class);
    private final TestScript<AppT> mScript;
    private final EnvironmentFactory<EnvironmentT> mEnvironmentFactory;
    private final EnvironmentPreparator<EnvironmentT> mEnvironmentPreparator;
    private final ApplicationFactory<EnvironmentT, AppT> mApplicationFactory;
    private final boolean mShouldPrepareEnvironments;
    private final boolean mShouldCleanEnvironments;
    private final Path mReportPath;

    public SingleTestRunner(TestScript<AppT> script, EnvironmentFactory<EnvironmentT> environmentFactory, EnvironmentPreparator<EnvironmentT> environmentPreparator, ApplicationFactory<EnvironmentT, AppT> applicationFactory, boolean shouldPrepareEnvironments, boolean shouldCleanEnvironments, Path reportPath) {
        this.mScript = script;
        this.mEnvironmentFactory = environmentFactory;
        this.mEnvironmentPreparator = environmentPreparator;
        this.mApplicationFactory = applicationFactory;
        this.mShouldPrepareEnvironments = shouldPrepareEnvironments;
        this.mShouldCleanEnvironments = shouldCleanEnvironments;
        this.mReportPath = reportPath;
    }

    @Override
    public TestResult run() {
        Collection<EnvironmentT> envs;
        LOGGER.info("run(): Starting preparation for test script {}.", (Object)this.mScript.toString());
        LOGGER.info("run(): Creating environments.");
        try {
            envs = this.mEnvironmentFactory.create();
        }
        catch (IOException e) {
            LOGGER.error("run(): Could not create environments.", (Throwable)e);
            return new TestResult(TestResult.Type.FAILURE, "Could not create environments.");
        }
        try {
            if (this.mShouldPrepareEnvironments) {
                LOGGER.info("run(): Preparing environments.");
                this.mEnvironmentPreparator.prepare(envs);
            } else {
                LOGGER.info("run(): Restoring environments.");
                this.mEnvironmentPreparator.restore(envs);
            }
            LOGGER.info("run(): Environments prepared: ", (Object)envs.size());
        }
        catch (IOException e) {
            LOGGER.error("run(): Could not prepare environments.", (Throwable)e);
            this.mEnvironmentFactory.destroy(envs);
            return new TestResult(TestResult.Type.FAILURE, "Could not prepare environments.");
        }
        LinkedList<AppT> apps = new LinkedList<AppT>();
        for (Environment env : envs) {
            apps.add(this.mApplicationFactory.newApp(env));
        }
        TestResult result = this.mScript.run(apps);
        LOGGER.info("run(): Collecting output and log files.");
        this.mEnvironmentPreparator.collectOutputAndLogFiles(envs, this.mReportPath);
        if (this.mShouldCleanEnvironments) {
            this.mEnvironmentPreparator.clean(envs);
            this.mEnvironmentFactory.destroy(envs);
        }
        return result;
    }
}

