/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.SSHEnvironment;
import me.gregorias.dfuntest.util.FileUtilsImpl;
import me.gregorias.dfuntest.util.SSHClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHEnvironmentFactory
implements EnvironmentFactory<Environment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHEnvironmentFactory.class);
    private final List<InetAddress> mHosts;
    private final String mUsername;
    private final Path mPrivateKeyPath;
    private final String mRemoteDir;
    private final Executor mExecutor;

    public SSHEnvironmentFactory(Collection<InetAddress> hosts, String username, Path privateKeyPath, String remoteDir, Executor executor) {
        if (hosts.size() == 0) {
            throw new IllegalArgumentException("Hosts collection is empty.");
        }
        this.mHosts = new ArrayList<InetAddress>(hosts);
        this.mUsername = username;
        this.mPrivateKeyPath = privateKeyPath;
        this.mRemoteDir = remoteDir;
        this.mExecutor = executor;
    }

    @Override
    public Collection<Environment> create() throws IOException {
        LOGGER.info("create()");
        ArrayList<Environment> environments = new ArrayList<Environment>();
        for (int envIdx = 0; envIdx < this.mHosts.size(); ++envIdx) {
            LOGGER.trace("create(): Setting up environment for host: {}.", (Object)this.mHosts.get(envIdx).toString());
            SSHEnvironment env = new SSHEnvironment(envIdx, this.mUsername, this.mPrivateKeyPath, this.mHosts.get(envIdx), this.mRemoteDir, this.mExecutor, SSHClientFactory.getSSHClientFactory(), FileUtilsImpl.getFileUtilsImpl());
            environments.add(env);
        }
        return environments;
    }

    @Override
    public void destroy(Collection<Environment> envs) {
        LOGGER.info("destroy()");
    }
}

