/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactoryBuilder;
import me.gregorias.dfuntest.SSHEnvironmentFactory;
import org.apache.commons.configuration.Configuration;

public class SSHEnvironmentFactoryBuilder
implements EnvironmentFactoryBuilder<Environment> {
    public static final String XML_HOSTS_FIELD = "hosts";
    public static final String XML_USERNAME_FIELD = "username";
    public static final String XML_PRIVATE_KEY_PATH_FIELD = "private-key-path";
    public static final String XML_REMOTE_DIR_FIELD = "remote-dir";

    public SSHEnvironmentFactory newEnvironmentFactory(Configuration configuration, Executor executor) throws IOException {
        List hostsList = configuration.getList(XML_HOSTS_FIELD);
        String username = configuration.getString(XML_USERNAME_FIELD);
        String privateKeyPathString = configuration.getString(XML_PRIVATE_KEY_PATH_FIELD);
        String remoteDir = configuration.getString(XML_REMOTE_DIR_FIELD);
        if (hostsList.size() == 0 || null == username || null == privateKeyPathString || null == remoteDir) {
            throw new IllegalArgumentException("One of the required fields is missing or is in wrong format.");
        }
        ArrayList<InetAddress> hosts = new ArrayList<InetAddress>();
        for (Object host : hostsList) {
            hosts.add(InetAddress.getByName((String)host));
        }
        Path privateKeyPath = FileSystems.getDefault().getPath(privateKeyPathString, new String[0]);
        return new SSHEnvironmentFactory(hosts, username, privateKeyPath, remoteDir, executor);
    }
}

