/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import me.gregorias.dfuntest.util.FileUtils;

public class FileUtilsImpl
implements FileUtils {
    private static FileUtilsImpl FILE_UTILS_IMPL = new FileUtilsImpl();

    @Override
    public void copyDirectoryToDirectory(File from, File to) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectoryToDirectory((File)from, (File)to);
    }

    @Override
    public void copyFileToDirectory(File from, File to) throws IOException {
        org.apache.commons.io.FileUtils.copyFileToDirectory((File)from, (File)to);
    }

    @Override
    public void createDirectories(Path path) throws IOException {
        Files.createDirectories(path, new FileAttribute[0]);
    }

    @Override
    public Path createTempDirectory(String dirPrefix) throws IOException {
        return Files.createTempDirectory(dirPrefix, new FileAttribute[0]);
    }

    @Override
    public boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    @Override
    public boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public static FileUtilsImpl getFileUtilsImpl() {
        return FILE_UTILS_IMPL;
    }

    @Override
    public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    public Process runCommand(List<String> command, File pwdFile) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(command).directory(pwdFile);
        return pb.start();
    }

    @Override
    public void write(Path path, String content) throws IOException {
        OpenOption[] options = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND};
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(content);
        Files.write(path, lines, Charset.defaultCharset(), options);
    }
}

