/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.LocalEnvironment;
import me.gregorias.dfuntest.util.FileUtils;
import me.gregorias.dfuntest.util.FileUtilsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalEnvironmentFactory
implements EnvironmentFactory<Environment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalEnvironmentFactory.class);
    private static final String ENV_CONFIG_ROOT_DIR = "local-environment-factory-root-dir";
    private final int mEnvironmentCount;
    private final String mDirPrefix;
    private final FileUtils mFileUtils;

    public LocalEnvironmentFactory(int environmentCount, String dirPrefix, FileUtils fileUtils) {
        if (environmentCount <= 0) {
            throw new IllegalArgumentException("Number of environments was nonpositive.");
        }
        this.mEnvironmentCount = environmentCount;
        this.mDirPrefix = dirPrefix;
        this.mFileUtils = fileUtils;
    }

    public LocalEnvironmentFactory(int environmentCount, String dirPrefix) {
        this(environmentCount, dirPrefix, FileUtilsImpl.getFileUtilsImpl());
    }

    @Override
    public Collection<Environment> create() throws IOException {
        LOGGER.info("create()");
        ArrayList<Environment> environments = new ArrayList<Environment>();
        for (int envIdx = 0; envIdx < this.mEnvironmentCount; ++envIdx) {
            Path tempDirPath = this.mFileUtils.createTempDirectory(this.mDirPrefix);
            LocalEnvironment env = new LocalEnvironment(envIdx, tempDirPath, this.mFileUtils);
            env.setProperty(ENV_CONFIG_ROOT_DIR, tempDirPath);
            environments.add(env);
        }
        return environments;
    }

    @Override
    public void destroy(Collection<Environment> envs) {
        LOGGER.info("destroy()");
        for (Environment env : envs) {
            Path dirPath;
            try {
                dirPath = (Path)env.getProperty(ENV_CONFIG_ROOT_DIR);
            }
            catch (ClassCastException | NoSuchElementException e) {
                LOGGER.error("Could not destroy environment.", (Throwable)e);
                continue;
            }
            this.mFileUtils.deleteQuietly(dirPath.toFile());
        }
    }
}

