/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import me.gregorias.dfuntest.App;
import me.gregorias.dfuntest.ApplicationFactory;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.EnvironmentPreparator;
import me.gregorias.dfuntest.MultiTestRunner;
import me.gregorias.dfuntest.TestRunner;
import me.gregorias.dfuntest.TestScript;
import me.gregorias.dfuntest.util.FileUtils;
import me.gregorias.dfuntest.util.FileUtilsImpl;

public class RunnerBuilder<EnvironmentT extends Environment, AppT extends App<EnvironmentT>> {
    private EnvironmentFactory<EnvironmentT> mEnvironmentFactory;
    private EnvironmentPreparator<EnvironmentT> mEnvironmentPreparator;
    private ApplicationFactory<EnvironmentT, AppT> mApplicationFactory;
    private final Collection<TestScript<AppT>> mTestScripts = new ArrayList<TestScript<AppT>>();
    private boolean mShouldPrepareEnvironments = true;
    private boolean mShouldCleanEnvironments = true;
    private Path mReportPath;

    public RunnerBuilder<EnvironmentT, AppT> addTestScript(TestScript<AppT> testScript) {
        this.mTestScripts.add(testScript);
        return this;
    }

    public TestRunner buildRunner() {
        if (this.mTestScripts.size() == 0 || null == this.mEnvironmentFactory || null == this.mEnvironmentPreparator || null == this.mApplicationFactory || null == this.mReportPath) {
            throw new IllegalStateException("One of runner's dependencies was not set.");
        }
        return new MultiTestRunner<EnvironmentT, AppT>(this.mTestScripts, this.mEnvironmentFactory, this.mEnvironmentPreparator, this.mApplicationFactory, this.mShouldPrepareEnvironments, this.mShouldCleanEnvironments, this.mReportPath, (FileUtils)FileUtilsImpl.getFileUtilsImpl());
    }

    public RunnerBuilder<EnvironmentT, AppT> setApplicationFactory(ApplicationFactory<EnvironmentT, AppT> applicationFactory) {
        this.mApplicationFactory = applicationFactory;
        return this;
    }

    public RunnerBuilder<EnvironmentT, AppT> setEnvironmentFactory(EnvironmentFactory<EnvironmentT> environmentFactory) {
        this.mEnvironmentFactory = environmentFactory;
        return this;
    }

    public RunnerBuilder<EnvironmentT, AppT> setEnvironmentPreparator(EnvironmentPreparator<EnvironmentT> environmentPreparator) {
        this.mEnvironmentPreparator = environmentPreparator;
        return this;
    }

    public RunnerBuilder<EnvironmentT, AppT> setReportPath(Path reportPath) {
        this.mReportPath = reportPath;
        return this;
    }

    public RunnerBuilder<EnvironmentT, AppT> setShouldPrepareEnvironments(boolean should) {
        this.mShouldPrepareEnvironments = should;
        return this;
    }

    public RunnerBuilder<EnvironmentT, AppT> setShouldCleanEnvironments(boolean should) {
        this.mShouldCleanEnvironments = should;
        return this;
    }
}

