/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import me.gregorias.dfuntest.AbstractConfigurationEnvironment;
import me.gregorias.dfuntest.RemoteProcess;
import me.gregorias.dfuntest.util.FileUtils;

public class LocalEnvironment
extends AbstractConfigurationEnvironment {
    private final int mId;
    private final Path mDir;
    private final FileUtils mFileUtils;

    public LocalEnvironment(int id, Path dir, FileUtils fileUtils) {
        this.mId = id;
        this.mDir = dir;
        this.mFileUtils = fileUtils;
    }

    @Override
    public void copyFilesFromLocalDisk(Path srcPath, String destRelPath) throws IOException {
        Path destPath = this.mDir.resolve(destRelPath);
        if (!this.mFileUtils.exists(destPath)) {
            this.mFileUtils.createDirectories(destPath);
        } else if (!this.mFileUtils.isDirectory(destPath)) {
            throw new IOException("Destination path exists and it is not a directory.");
        }
        if (this.mFileUtils.isDirectory(srcPath)) {
            this.mFileUtils.copyDirectoryToDirectory(srcPath.toFile(), destPath.toFile());
        } else {
            this.mFileUtils.copyFileToDirectory(srcPath.toFile(), destPath.toFile());
        }
    }

    @Override
    public void copyFilesToLocalDisk(String srcRelPath, Path destPath) throws IOException {
        Path srcPath = this.mDir.resolve(srcRelPath);
        if (!this.mFileUtils.exists(destPath)) {
            this.mFileUtils.createDirectories(destPath);
        } else if (!this.mFileUtils.isDirectory(destPath)) {
            throw new IOException("Destination path exists and it is not a directory.");
        }
        if (this.mFileUtils.isDirectory(srcPath)) {
            this.mFileUtils.copyDirectoryToDirectory(srcPath.toFile(), destPath.toFile());
        } else {
            this.mFileUtils.copyFileToDirectory(srcPath.toFile(), destPath.toFile());
        }
    }

    @Override
    public String getHostname() {
        return "localhost";
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mDir.toAbsolutePath().toString();
    }

    @Override
    public RemoteProcess runCommand(List<String> command) throws InterruptedException, IOException {
        RemoteProcess process = this.runCommandAsynchronously(command);
        process.waitFor();
        return process;
    }

    @Override
    public RemoteProcess runCommandAsynchronously(List<String> command) throws IOException {
        Process process = this.mFileUtils.runCommand(command, this.mDir.toFile());
        return new ProcessAdapter(process);
    }

    @Override
    public void removeFile(String relPath) {
        this.mFileUtils.deleteQuietly(this.mDir.resolve(relPath).toFile());
    }

    private static class ProcessAdapter
    implements RemoteProcess {
        private final Process mProcess;

        public ProcessAdapter(Process process) {
            this.mProcess = process;
        }

        @Override
        public void destroy() {
            this.mProcess.destroy();
        }

        @Override
        public InputStream getErrorStream() {
            return this.mProcess.getErrorStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.mProcess.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.mProcess.getOutputStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.mProcess.waitFor();
        }
    }
}

