/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import me.gregorias.dfuntest.AbstractConfigurationEnvironment;
import me.gregorias.dfuntest.RemoteProcess;
import me.gregorias.dfuntest.util.FileUtils;
import me.gregorias.dfuntest.util.SSHClientFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHEnvironment
extends AbstractConfigurationEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHEnvironment.class);
    private final int mId;
    private final String mRemoteHomePath;
    private final String mUsername;
    private final Path mPrivateKeyPath;
    private final InetAddress mRemoteInetAddress;
    private final Executor mExecutor;
    private final SSHClientFactory mSSHClientFactory;
    private final FileUtils mFileUtils;

    public SSHEnvironment(int id, String username, Path privateKeyPath, InetAddress remoteInetAddress, String remoteHomePath, Executor executor, SSHClientFactory sshClientFactory, FileUtils fileUtils) {
        this.mId = id;
        this.mRemoteHomePath = remoteHomePath;
        this.mUsername = username;
        this.mPrivateKeyPath = privateKeyPath;
        this.mRemoteInetAddress = remoteInetAddress;
        this.mExecutor = executor;
        this.mSSHClientFactory = sshClientFactory;
        this.mFileUtils = fileUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFilesFromLocalDisk(Path srcPath, String destRelPath) throws IOException {
        LOGGER.trace("copyFilesFromLocalDisk({}, {})", (Object)srcPath.toString(), (Object)destRelPath);
        this.mkdirs(destRelPath);
        String remotePath = this.concatenatePathToHome(destRelPath);
        SSHClient ssh = this.connectWithSSH();
        try {
            ssh.useCompression();
            ssh.newSCPFileTransfer().upload((LocalSourceFile)new FileSystemFile(srcPath.toFile()), remotePath);
        }
        finally {
            ssh.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFilesToLocalDisk(String srcRelPath, Path destPath) throws IOException {
        LOGGER.trace("copyFilesToLocalDisk({}, {})", (Object)srcRelPath, (Object)destPath.toString());
        this.createDestinationDirectoriesLocally(destPath);
        SSHClient ssh = this.connectWithSSH();
        try {
            ssh.useCompression();
            String remotePath = this.concatenatePathToHome(srcRelPath);
            ssh.newSCPFileTransfer().download(remotePath, (LocalDestFile)new FileSystemFile(destPath.toFile()));
        }
        finally {
            ssh.disconnect();
        }
    }

    @Override
    public String getHostname() {
        return this.mRemoteInetAddress.getHostName();
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mRemoteInetAddress.getHostName();
    }

    public String getRemoteHomePath() {
        return this.mRemoteHomePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdirs(String directoryPath) throws IOException {
        LOGGER.trace("mkdirs({})", (Object)directoryPath);
        String finalDirectoryPath = this.concatenatePathToHome(directoryPath);
        FilenameUtils.normalize((String)finalDirectoryPath, (boolean)true);
        if (!finalDirectoryPath.startsWith("/")) {
            finalDirectoryPath = "./" + finalDirectoryPath;
        }
        SSHClient ssh = this.connectWithSSH();
        try {
            try (SFTPClient sftp = ssh.newSFTPClient();){
                sftp.mkdirs(finalDirectoryPath);
            }
            catch (IOException e) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("mkdir");
                command.add("-p");
                command.add(finalDirectoryPath);
                String sshHomeDir = ".";
                int exitStatus = this.runCommand(command, ssh, sshHomeDir);
                if (exitStatus != 0) {
                    throw new IOException("Could not create suggested directories.");
                }
            }
        }
        finally {
            ssh.disconnect();
        }
    }

    @Override
    public void removeFile(String relPath) throws InterruptedException, IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add("rm");
        command.add("-rf");
        command.add(relPath);
        RemoteProcess finishedProcess = this.runCommand(command);
        int exitCode = finishedProcess.waitFor();
        if (exitCode != 0) {
            throw new IOException(String.format("Removal of %s has ended with failure exit code: %d", relPath, exitCode));
        }
    }

    public int runCommand(List<String> command, String pwdDir) throws IOException {
        SSHClient ssh = this.connectWithSSH();
        try {
            int n = this.runCommand(command, ssh, pwdDir);
            return n;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                ssh.disconnect();
            }
            catch (IOException ioException) {
                LOGGER.warn("runCommand(): Could not disconnect ssh.", (Throwable)ioException);
            }
        }
    }

    @Override
    public RemoteProcess runCommand(List<String> command) throws InterruptedException, IOException {
        SSHClient ssh = this.connectWithSSH();
        try {
            ProcessAdapter process = this.runCommandAndWrapInProcessAdapter(command, ssh);
            process.run();
            process.waitFor();
            return process;
        }
        catch (IOException | InterruptedException e) {
            try {
                ssh.disconnect();
            }
            catch (IOException ioException) {
                LOGGER.warn("runCommand(): Could not disconnect ssh.", (Throwable)ioException);
            }
            throw e;
        }
    }

    @Override
    public RemoteProcess runCommandAsynchronously(List<String> command) throws IOException {
        SSHClient ssh = this.connectWithSSH();
        try {
            ProcessAdapter process = this.runCommandAndWrapInProcessAdapter(command, ssh);
            this.mExecutor.execute(process);
            return process;
        }
        catch (IOException e) {
            try {
                ssh.disconnect();
            }
            catch (IOException ioException) {
                LOGGER.warn("runCommandAsynchronously(): Could not disconnect ssh.", (Throwable)ioException);
            }
            throw e;
        }
    }

    private String concatenatePathToHome(String relPath) {
        String finalPath = FilenameUtils.concat((String)this.mRemoteHomePath, (String)relPath);
        if (finalPath == null) {
            throw new IllegalArgumentException("Provided path can not be concatenated to home path.");
        }
        return finalPath;
    }

    private SSHClient connectWithSSH() throws IOException {
        SSHClient ssh = this.mSSHClientFactory.newSSHClient();
        ssh.loadKnownHosts();
        ssh.connect(this.mRemoteInetAddress);
        ssh.authPublickey(this.mUsername, new String[]{this.mPrivateKeyPath.toString()});
        return ssh;
    }

    private void createDestinationDirectoriesLocally(Path destPath) throws IOException {
        this.mFileUtils.createDirectories(destPath);
    }

    private int runCommand(List<String> command, SSHClient ssh, String pwdDir) throws IOException {
        String cdCommand = "cd " + pwdDir + ";";
        try (Session session = ssh.startSession();){
            Session.Command cmd = session.exec(cdCommand + StringUtils.join(command, (char)' '));
            cmd.join();
            int exitStatus = cmd.getExitStatus();
            cmd.close();
            int n = exitStatus;
            return n;
        }
    }

    private ProcessAdapter runCommandAndWrapInProcessAdapter(List<String> command, SSHClient ssh) throws IOException {
        String cdCommand = "cd " + this.mRemoteHomePath + ";";
        Session session = ssh.startSession();
        try {
            Session.Command cmd = session.exec(cdCommand + StringUtils.join(command, (char)' '));
            return new ProcessAdapter(ssh, session, cmd);
        }
        catch (IOException e) {
            session.close();
            throw e;
        }
    }

    private static class ProcessAdapter
    implements RemoteProcess,
    Runnable {
        private final SSHClient mSSHClient;
        private boolean mHasSSHClientBeenClosed = false;
        private final Session mSSHSession;
        private final Session.Command mCommand;
        private final AtomicBoolean mHasJoined = new AtomicBoolean(false);
        private IOException mIOException;
        private int mExitCode;

        public ProcessAdapter(SSHClient client, Session session, Session.Command command) {
            this.mSSHClient = client;
            this.mCommand = command;
            this.mSSHSession = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void destroy() throws IOException {
            SSHClient sSHClient = this.mSSHClient;
            synchronized (sSHClient) {
                if (!this.mHasSSHClientBeenClosed) {
                    this.mSSHClient.disconnect();
                    this.mHasSSHClientBeenClosed = true;
                }
            }
        }

        @Override
        public InputStream getErrorStream() {
            return this.mCommand.getErrorStream();
        }

        @Override
        public InputStream getInputStream() {
            return this.mCommand.getInputStream();
        }

        @Override
        public OutputStream getOutputStream() {
            return this.mCommand.getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mCommand.join();
                this.mExitCode = this.mCommand.getExitStatus();
                this.mCommand.close();
            }
            catch (IOException e) {
                LOGGER.error("run(): Could not correctly wait for command finish.", (Throwable)e);
                this.mIOException = e;
            }
            finally {
                ProcessAdapter e = this;
                synchronized (e) {
                    this.mHasJoined.set(true);
                    this.notifyAll();
                }
                try {
                    this.mSSHSession.close();
                }
                catch (IOException e2) {
                    LOGGER.warn("run(): Could not close SSHSession.", (Throwable)e2);
                }
                try {
                    e = this.mSSHClient;
                    synchronized (e) {
                        if (!this.mHasSSHClientBeenClosed) {
                            this.mSSHClient.disconnect();
                            this.mHasSSHClientBeenClosed = true;
                        }
                    }
                }
                catch (IOException e3) {
                    LOGGER.warn("run(): Could not disconnect SSHClient.", (Throwable)e3);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int waitFor() throws InterruptedException, IOException {
            ProcessAdapter processAdapter = this;
            synchronized (processAdapter) {
                while (!this.mHasJoined.get()) {
                    this.wait();
                }
            }
            if (this.mIOException != null) {
                throw this.mIOException;
            }
            return this.mExitCode;
        }
    }
}

