/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import com.google.inject.Inject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Named;
import me.gregorias.dfuntest.App;
import me.gregorias.dfuntest.ApplicationFactory;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.EnvironmentPreparator;
import me.gregorias.dfuntest.TestResult;
import me.gregorias.dfuntest.TestRunner;
import me.gregorias.dfuntest.TestScript;
import me.gregorias.dfuntest.util.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTestRunner<EnvironmentT extends Environment, AppT extends App<EnvironmentT>>
implements TestRunner {
    public static final String REPORT_FILENAME = "report.txt";
    public static final String SCRIPTS_ARGUMENT_NAME = "MultiTestRunner.scripts";
    public static final String SHOULD_PREPARE_ARGUMENT_NAME = "MultiTestRunner.shouldPrepareEnvironments";
    public static final String SHOULD_CLEAN_ARGUMENT_NAME = "MultiTestRunner.shouldCleanEnvironments";
    public static final String REPORT_PATH_ARGUMENT_NAME = "MultiTestRunner.reportPath";
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTestRunner.class);
    private final Collection<TestScript<AppT>> mScripts;
    private final EnvironmentFactory<EnvironmentT> mEnvironmentFactory;
    private final EnvironmentPreparator<EnvironmentT> mEnvironmentPreparator;
    private final ApplicationFactory<EnvironmentT, AppT> mApplicationFactory;
    private final boolean mShouldPrepareEnvironments;
    private final boolean mShouldCleanEnvironments;
    private final Path mReportPath;
    private final FileUtils mFileUtils;
    private final Path mSummaryReportPath;

    public MultiTestRunner(TestScript<AppT> script, EnvironmentFactory<EnvironmentT> environmentFactory, EnvironmentPreparator<EnvironmentT> environmentPreparator, ApplicationFactory<EnvironmentT, AppT> applicationFactory, boolean shouldPrepareEnvironments, boolean shouldCleanEnvironments, Path reportPath, FileUtils fileUtils) {
        this.mScripts = new ArrayList<TestScript<AppT>>();
        this.mScripts.add(script);
        this.mEnvironmentFactory = environmentFactory;
        this.mEnvironmentPreparator = environmentPreparator;
        this.mApplicationFactory = applicationFactory;
        this.mShouldPrepareEnvironments = shouldPrepareEnvironments;
        this.mShouldCleanEnvironments = shouldCleanEnvironments;
        this.mReportPath = reportPath;
        this.mFileUtils = fileUtils;
        this.mSummaryReportPath = this.mReportPath.resolve(REPORT_FILENAME);
    }

    @Inject
    public MultiTestRunner(@Named(value="MultiTestRunner.scripts") Set<TestScript<AppT>> scripts, EnvironmentFactory<EnvironmentT> environmentFactory, EnvironmentPreparator<EnvironmentT> environmentPreparator, ApplicationFactory<EnvironmentT, AppT> applicationFactory, @Named(value="MultiTestRunner.shouldPrepareEnvironments") boolean shouldPrepareEnvironments, @Named(value="MultiTestRunner.shouldCleanEnvironments") boolean shouldCleanEnvironments, @Named(value="MultiTestRunner.reportPath") Path reportPath, FileUtils fileUtils) {
        this.mScripts = scripts;
        this.mEnvironmentFactory = environmentFactory;
        this.mEnvironmentPreparator = environmentPreparator;
        this.mApplicationFactory = applicationFactory;
        this.mShouldPrepareEnvironments = shouldPrepareEnvironments;
        this.mShouldCleanEnvironments = shouldCleanEnvironments;
        this.mReportPath = reportPath;
        this.mFileUtils = fileUtils;
        this.mSummaryReportPath = this.mReportPath.resolve(REPORT_FILENAME);
    }

    @Override
    public TestResult run() {
        Collection<EnvironmentT> envs;
        LOGGER.info("run()");
        LOGGER.debug("run(): Creating environments.");
        try {
            envs = this.mEnvironmentFactory.create();
        }
        catch (IOException e) {
            LOGGER.error("run(): Could not create environments.", (Throwable)e);
            return new TestResult(TestResult.Type.FAILURE, "Could not create environments.");
        }
        boolean hasPrepared = false;
        ArrayList<String> failedTests = new ArrayList<String>();
        for (TestScript testScript : this.mScripts) {
            LOGGER.debug("run(): Preparing and running {}.", testScript);
            try {
                if (this.mShouldPrepareEnvironments && !hasPrepared) {
                    LOGGER.debug("run(): Preparing environments.");
                    this.mEnvironmentPreparator.prepare(envs);
                    hasPrepared = true;
                } else {
                    LOGGER.debug("run(): Restoring environments.");
                    this.mEnvironmentPreparator.restore(envs);
                }
                LOGGER.debug("run(): Environments were prepared or restored successfully.");
            }
            catch (IOException e) {
                String errorMsg = String.format("Could not prepare environments for %s.", testScript.toString());
                LOGGER.error("run(): " + errorMsg, testScript, (Object)e);
                this.saveResultToSummaryReportFile(new TestResult(TestResult.Type.FAILURE, errorMsg), testScript);
                failedTests.add(testScript.toString());
                continue;
            }
            ArrayList<AppT> apps = new ArrayList<AppT>();
            for (Environment env : envs) {
                apps.add(this.mApplicationFactory.newApp(env));
            }
            LOGGER.info("run(): Running test {}", testScript);
            TestResult scriptResult = testScript.run(apps);
            LOGGER.info("run(): Test {} has ended with {}", testScript, (Object)scriptResult.getType());
            if (scriptResult.getType() == TestResult.Type.FAILURE) {
                failedTests.add(testScript.toString());
            }
            LOGGER.debug("run(): Collecting output and log files.");
            Path testReportPath = this.mReportPath.resolve(testScript.toString());
            this.mEnvironmentPreparator.collectOutput(envs, testReportPath);
            this.saveResultToSummaryReportFile(scriptResult, testScript);
            this.saveResultToScriptReportFile(scriptResult, testReportPath);
            if (this.mShouldPrepareEnvironments && this.mShouldCleanEnvironments) {
                LOGGER.debug("run(): Cleaning environments completely.");
                this.mEnvironmentPreparator.cleanAll(envs);
                hasPrepared = false;
                continue;
            }
            LOGGER.debug("run(): Cleaning output in environments.");
            this.mEnvironmentPreparator.cleanOutput(envs);
        }
        if (this.mShouldCleanEnvironments) {
            LOGGER.debug("run(): Destroying environments.");
            this.mEnvironmentFactory.destroy(envs);
        }
        if (failedTests.isEmpty()) {
            return new TestResult(TestResult.Type.SUCCESS, "TestRunner has run all tests successfully.");
        }
        return new TestResult(TestResult.Type.FAILURE, "Some tests have failed: " + StringUtils.join(failedTests, (String)" "));
    }

    private void createParentDirectories(Path destPath) throws IOException {
        Path parentPath = destPath.getParent();
        assert (parentPath != null) : "Destination path pointed to current directory.";
        this.mFileUtils.createDirectories(parentPath);
    }

    private String getResultTypeString(TestResult.Type type) {
        switch (type) {
            case SUCCESS: {
                return "[SUCCESS]";
            }
        }
        return "[FAILURE]";
    }

    private boolean saveResultToSummaryReportFile(TestResult scriptResult, TestScript<AppT> script) {
        String resultString = this.getResultTypeString(scriptResult.getType());
        try {
            String content = resultString + " " + script.toString();
            this.createParentDirectories(this.mSummaryReportPath);
            this.mFileUtils.write(this.mSummaryReportPath, content);
        }
        catch (IOException e) {
            LOGGER.warn("saveResultToReportFile(): Could not append to summary report file.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void saveResultToScriptReportFile(TestResult scriptResult, Path testScriptReportPath) {
        String resultString = this.getResultTypeString(scriptResult.getType());
        Path testScriptSummaryReportPath = testScriptReportPath.resolve(REPORT_FILENAME);
        try {
            String content = resultString + " " + scriptResult.getDescription();
            this.createParentDirectories(testScriptSummaryReportPath);
            this.mFileUtils.write(testScriptSummaryReportPath, content);
        }
        catch (IOException e) {
            LOGGER.warn("saveResultToReportFile(): Could not append to report file.", (Throwable)e);
        }
    }
}

