/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import me.gregorias.dfuntest.Environment;
import me.gregorias.dfuntest.EnvironmentFactory;
import me.gregorias.dfuntest.SSHEnvironment;
import me.gregorias.dfuntest.util.FileUtilsImpl;
import me.gregorias.dfuntest.util.SSHClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHEnvironmentFactory
implements EnvironmentFactory<Environment> {
    public static final String HOSTS_ARGUMENT_NAME = "SSHEnvironmentFactory.hosts";
    public static final String USERNAME_ARGUMENT_NAME = "SSHEnvironmentFactory.username";
    public static final String PRIVATE_KEY_PATH = "SSHEnvironmentFactory.privateKeyPath";
    public static final String REMOTE_DIR_ARGUMENT_NAME = "SSHEnvironmentFactory.remoteDir";
    public static final String EXECUTOR_ARGUMENT_NAME = "SSHEnvironmentFactory.executor";
    private static final Logger LOGGER = LoggerFactory.getLogger(SSHEnvironmentFactory.class);
    private final List<String> mHostnames;
    private final String mUsername;
    private final Path mPrivateKeyPath;
    private final String mRemoteDir;
    private final Executor mExecutor;

    @Inject
    public SSHEnvironmentFactory(@Named(value="SSHEnvironmentFactory.hosts") Collection<String> hosts, @Named(value="SSHEnvironmentFactory.username") String username, @Named(value="SSHEnvironmentFactory.privateKeyPath") Path privateKeyPath, @Named(value="SSHEnvironmentFactory.remoteDir") String remoteDir, @Named(value="SSHEnvironmentFactory.executor") Executor executor) {
        if (hosts.size() == 0) {
            throw new IllegalArgumentException("Hosts collection is empty.");
        }
        this.mHostnames = new ArrayList<String>(hosts);
        this.mUsername = username;
        this.mPrivateKeyPath = privateKeyPath;
        this.mRemoteDir = remoteDir;
        this.mExecutor = executor;
    }

    @Override
    public Collection<Environment> create() throws IOException {
        LOGGER.info("create()");
        ArrayList<Environment> environments = new ArrayList<Environment>();
        for (int envIdx = 0; envIdx < this.mHostnames.size(); ++envIdx) {
            LOGGER.trace("create(): Setting up environment for host: {}.", (Object)this.mHostnames.get(envIdx));
            InetAddress hostInetAddress = InetAddress.getByName(this.mHostnames.get(envIdx));
            SSHEnvironment env = new SSHEnvironment(envIdx, this.mUsername, this.mPrivateKeyPath, hostInetAddress, this.mRemoteDir, this.mExecutor, SSHClientFactory.getSSHClientFactory(), FileUtilsImpl.getFileUtilsImpl());
            environments.add(env);
        }
        return environments;
    }

    @Override
    public void destroy(Collection<Environment> envs) {
        String errorMsg = "destroy(): Could not destroy environment due to exception.";
        for (Environment env : envs) {
            SSHEnvironment ssh = (SSHEnvironment)env;
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.add("rmdir");
                command.add(ssh.getRemoteHomePath());
                int exitStatus = ssh.runCommand(command, ".");
                if (exitStatus == 0) continue;
                LOGGER.error("destroy(): rmdir command has failed with status {}.", (Object)exitStatus);
            }
            catch (IOException e) {
                LOGGER.error(errorMsg, (Throwable)e);
            }
        }
        LOGGER.info("destroy()");
    }
}

