/*
 * Decompiled with CFR 0.152.
 */
package me.gregorias.dfuntest.testrunnerbuilders;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeConverter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import me.gregorias.dfuntest.util.FileUtils;
import me.gregorias.dfuntest.util.FileUtilsImpl;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ConfigurationNodeVisitor;
import org.apache.commons.lang.StringUtils;

public class GuiceTestRunnerModule
extends AbstractModule {
    private final Map<String, String> mProperties = new HashMap<String, String>();

    public static Map<String, String> configurationToProperties(HierarchicalConfiguration configuration) {
        PropertiesBuilderVisitor visitor = new PropertiesBuilderVisitor();
        configuration.getRootNode().visit((ConfigurationNodeVisitor)visitor);
        return visitor.getProperties();
    }

    public void addProperty(String key, String value) {
        this.mProperties.put(key, value);
    }

    public void addProperties(Map<String, String> properties) {
        this.mProperties.putAll(properties);
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), this.mProperties);
        this.binder().convertToTypes(Matchers.only((Object)TypeLiteral.get(Path.class)), (TypeConverter)new StringToPathTypeConverter());
        this.binder().convertToTypes(Matchers.only((Object)((Object)new CollectionOfStringsTypeLiteral())), (TypeConverter)new StringToCollectionOfStringsTypeConverter());
    }

    @Provides
    @Singleton
    FileUtils provideFileUtils() {
        return FileUtilsImpl.getFileUtilsImpl();
    }

    private static class StringToPathTypeConverter
    implements TypeConverter {
        private StringToPathTypeConverter() {
        }

        public Object convert(String value, TypeLiteral<?> toType) {
            return FileSystems.getDefault().getPath(value, new String[0]);
        }
    }

    private static class StringToCollectionOfStringsTypeConverter
    implements TypeConverter {
        private StringToCollectionOfStringsTypeConverter() {
        }

        public Object convert(String value, TypeLiteral<?> toType) {
            String[] values = value.split(",");
            ArrayList<String> valuesCollection = new ArrayList<String>();
            for (String arrayValue : values) {
                valuesCollection.add(arrayValue.trim());
            }
            return valuesCollection;
        }
    }

    private static class CollectionOfStringsTypeLiteral
    extends TypeLiteral<Collection<String>> {
        private CollectionOfStringsTypeLiteral() {
        }
    }

    private static class PropertiesBuilderVisitor
    implements ConfigurationNodeVisitor {
        private final Map<String, String> mProperties = new HashMap<String, String>();
        private final Stack<String> mPrefixes = new Stack();

        private PropertiesBuilderVisitor() {
        }

        public Map<String, String> getProperties() {
            return this.mProperties;
        }

        public void visitBeforeChildren(ConfigurationNode node) {
            this.mPrefixes.push(node.getName());
            if (node.getValue() != null) {
                String key = StringUtils.join(this.mPrefixes, (String)".");
                this.mProperties.put(key, (String)node.getValue());
            }
        }

        public void visitAfterChildren(ConfigurationNode node) {
            this.mPrefixes.pop();
        }

        public boolean terminate() {
            return false;
        }
    }
}

