/*
 * Decompiled with CFR 0.152.
 */
package me.haga.librespot.spotifi;

import java.io.IOException;
import me.haga.librespot.spotifi.util.SessionWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import xyz.gianlu.librespot.AbsConfiguration;
import xyz.gianlu.librespot.FileConfiguration;
import xyz.gianlu.librespot.core.ZeroconfServer;

@SpringBootApplication
public class SpotifiApplication {
    private static final Logger log = LogManager.getLogger(SpotifiApplication.class);
    @Autowired
    private static AbsConfiguration librespotConf;
    private static ZeroconfServer zeroconfServer;

    public static void main(String[] args) {
        try {
            librespotConf = new FileConfiguration(args);
        }
        catch (IOException e) {
            log.info("could not load config: ", (Throwable)e);
        }
        SpringApplication.run(SpotifiApplication.class, (String[])args);
    }

    @Bean
    public SessionWrapper getSessionWrapper() {
        try {
            if (zeroconfServer == null) {
                zeroconfServer = ZeroconfServer.create((AbsConfiguration)librespotConf);
            }
            return SessionWrapper.fromZeroconf((ZeroconfServer)zeroconfServer);
        }
        catch (IOException e) {
            log.info("could not start SessionWrapper: ", (Throwable)e);
            return null;
        }
    }

    public static AbsConfiguration getLibrespotConf() {
        return librespotConf;
    }

    public static ZeroconfServer getZeroconfServer() {
        return zeroconfServer;
    }
}

