/*
 * Decompiled with CFR 0.152.
 */
package me.haga.librespot.spotifi.controller;

import com.google.protobuf.ByteString;
import com.spotify.metadata.Metadata;
import java.util.Optional;
import me.haga.librespot.spotifi.model.CurrentSong;
import me.haga.librespot.spotifi.model.Image;
import me.haga.librespot.spotifi.model.PlayerLoadSong;
import me.haga.librespot.spotifi.util.SessionWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.gianlu.librespot.common.Utils;
import xyz.gianlu.librespot.mercury.model.EpisodeId;
import xyz.gianlu.librespot.mercury.model.ImageId;
import xyz.gianlu.librespot.mercury.model.PlayableId;
import xyz.gianlu.librespot.mercury.model.TrackId;
import xyz.gianlu.librespot.player.Player;

@CrossOrigin(origins={"*"})
@RestController
@RequestMapping(value={"player"})
public class PlayerController {
    private static final Logger log = LogManager.getLogger(PlayerController.class);
    private final SessionWrapper sessionWrapper;
    private Player player;

    public PlayerController(SessionWrapper sessionWrapper) {
        this.sessionWrapper = sessionWrapper;
    }

    @GetMapping(value={"current"}, produces={"application/json"})
    public ResponseEntity<?> getCurrentPlayList(@RequestParam(value="imgsize", defaultValue="0", required=false) Integer imgsize) {
        return this.getPlayer().map(song -> {
            try {
                PlayableId id = song.currentPlayableId();
                CurrentSong currentSong = new CurrentSong();
                currentSong.setImage(this.getImageFromCurrentSong(song, imgsize.intValue()));
                currentSong.setTrackTime(Long.valueOf(song.time()));
                if (id instanceof EpisodeId) {
                    currentSong.setEpisode(song.currentEpisode());
                }
                if (id instanceof TrackId) {
                    currentSong.setTrack(song.currentTrack());
                }
                return ResponseEntity.ok().body((Object)currentSong);
            }
            catch (IllegalArgumentException e) {
                return ResponseEntity.notFound().build();
            }
        }).orElse(ResponseEntity.notFound().build());
    }

    @PostMapping(value={"load"}, consumes={"application/json"})
    public ResponseEntity<?> loadSong(@RequestBody PlayerLoadSong loadSong) {
        return this.getPlayer().map(t -> {
            t.load(loadSong.getUri(), loadSong.getPlay().booleanValue());
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"pause"})
    public ResponseEntity<?> pause() {
        return this.getPlayer().map(t -> {
            t.pause();
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"resume"})
    public ResponseEntity<?> resume() {
        return this.getPlayer().map(t -> {
            t.play();
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"previous"})
    public ResponseEntity<?> previous() {
        return this.getPlayer().map(t -> {
            t.previous();
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"next"})
    public ResponseEntity<?> next() {
        return this.getPlayer().map(t -> {
            t.next();
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"volume/up"})
    public ResponseEntity<?> volumeUp() {
        return this.getPlayer().map(t -> {
            t.volumeUp();
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"volume/set/{volnr}"})
    public ResponseEntity<?> volumeSet(@PathVariable(value="volnr") Integer volnr) {
        return this.getPlayer().map(t -> {
            t.setVolume(volnr.intValue());
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"volume/down"})
    public ResponseEntity<?> volumeDown() {
        return this.getPlayer().map(t -> {
            t.volumeDown();
            return ResponseEntity.ok().build();
        }).orElse(ResponseEntity.notFound().build());
    }

    private Optional<Player> getPlayer() {
        if (this.sessionWrapper.get() != null) {
            this.player = this.sessionWrapper.get().player();
        }
        return Optional.ofNullable(this.player);
    }

    private Image getImageFromCurrentSong(Player t, int size) {
        Metadata.Track track = t.currentTrack();
        Metadata.Episode episode = t.currentEpisode();
        Metadata.Image image = null;
        if (track != null) {
            image = track.getAlbum().getCoverGroupOrBuilder().getImage(size);
        }
        if (episode != null) {
            image = episode.getCoverImageOrBuilder().getImage(size);
        }
        return Optional.ofNullable(image).map(y -> new Image(y.getHeight(), y.getWidth(), Integer.valueOf(y.getSize().getNumber()), ImageId.fromHex((String)Utils.bytesToHex((ByteString)y.getFileId())).hexId())).orElse(new Image(0, 0, Integer.valueOf(0), ""));
    }
}

