/*
 * Decompiled with CFR 0.152.
 */
package me.haga.librespot.spotifi.service;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import me.haga.librespot.spotifi.SpotifiApplication;
import me.haga.librespot.spotifi.model.ConfigData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import xyz.gianlu.librespot.AbsConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ConfigService {
    private static final Logger log = LogManager.getLogger(ConfigService.class);
    public static final AudioFormat OUTPUT_FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);
    @Value(value="${server.port}")
    private String port;
    @Value(value="${librespot.config}")
    private String configFileLocation;

    public ConfigData getConfigData() {
        AbsConfiguration librespotConf = SpotifiApplication.getLibrespotConf();
        ConfigData configData = new ConfigData();
        configData.setDeviceId(librespotConf.deviceId());
        configData.setDeviceName(librespotConf.deviceName());
        configData.setDeviceType(librespotConf.deviceType());
        configData.setChosenMixer(librespotConf.mixerSearchKeywords().length != 0 ? librespotConf.mixerSearchKeywords()[0] : "");
        configData.setLogLevel(librespotConf.loggingLevel().toString());
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, OUTPUT_FORMAT, -1);
        List availableMixers = ConfigService.findSupportingMixersFor((Line.Info)info).stream().map(mixer -> mixer.getMixerInfo().getName()).collect(Collectors.toList());
        configData.setAvailableMixers(availableMixers);
        try {
            configData.setUrl("http://" + InetAddress.getLocalHost().getHostAddress() + ":" + this.port);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return configData;
    }

    public void setConfigData(ConfigData configData) {
        FileConfig conf = FileConfig.of((String)this.configFileLocation);
        conf.load();
        conf.set("deviceName", (Object)configData.getDeviceName());
        conf.set("player.mixerSearchKeywords", (Object)configData.getChosenMixer());
        conf.set("logLevel", (Object)configData.getLogLevel());
        conf.save();
        conf.close();
        log.info("Shutdown of ZeroConfServer");
        try {
            SpotifiApplication.getZeroconfServer().closeSession();
            SpotifiApplication.getZeroconfServer().close();
        }
        catch (IOException e) {
            log.error("Could not shutdown ZeroConfServer: ", (Throwable)e);
        }
        System.exit(0);
    }

    private static List<Mixer> findSupportingMixersFor(@NotNull Line.Info info) {
        ArrayList<Mixer> mixers = new ArrayList<Mixer>();
        for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            if (!mixer.isLineSupported(info)) continue;
            mixers.add(mixer);
        }
        return mixers;
    }
}

