/*
 * Decompiled with CFR 0.152.
 */
package me.haga.librespot.spotifi.util;

import java.util.concurrent.atomic.AtomicReference;
import me.haga.librespot.spotifi.util.SessionWrapper;
import xyz.gianlu.librespot.core.Session;
import xyz.gianlu.librespot.core.ZeroconfServer;

public final class SessionWrapper {
    private final AtomicReference<Session> ref = new AtomicReference<Object>(null);
    private Listener listener = null;

    private SessionWrapper() {
    }

    public static SessionWrapper fromZeroconf(ZeroconfServer server) {
        SessionWrapper wrapper = new SessionWrapper();
        server.addSessionListener(arg_0 -> wrapper.set(arg_0));
        return wrapper;
    }

    public static SessionWrapper fromSession(Session session) {
        SessionWrapper wrapper = new SessionWrapper();
        wrapper.ref.set(session);
        return wrapper;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
        Session s = (Session)this.ref.get();
        if (s != null) {
            listener.onNewSession(s);
        }
    }

    private void set(Session session) {
        this.ref.set(session);
        session.addCloseListener(() -> this.clear());
        if (this.listener != null) {
            this.listener.onNewSession(session);
        }
    }

    private void clear() {
        this.ref.set(null);
        if (this.listener != null) {
            this.listener.onSessionCleared();
        }
    }

    public Session get() {
        Session s = (Session)this.ref.get();
        if (s != null) {
            if (s.isValid()) {
                return s;
            }
            this.clear();
        }
        return null;
    }
}

