package me.hdkz.seers.sign;


import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.hdkz.seers.sign.util.MD5Util;


public class Sign {

  private static final String hashKey = "SeerS.";
  private static final Set<Object> keySet = new HashSet<>(
      Arrays.asList("appKey", "timestamp")
  );

  private static String createSign(Map<String, Object> params, String appKey, String appSecret)
      throws NoSuchAlgorithmException {
    Object[] keyArray = keySet.toArray();
    Arrays.sort(keyArray);
    StringBuilder sb = new StringBuilder();
    if (keyArray.length > 0) {
      for (Object key : keyArray) {
        Object value = params.get(key.toString());
        String k = String.valueOf(key);
        String v = value != null ? String.valueOf(value) : "";
        sb.append(String.format("&%s%s=%s", hashKey, k, v));
      }
      sb.append(String.format("&%s:%s", appKey, appSecret));
    }
    return MD5Util.MD5(sb.toString()).toUpperCase();
  }

}
