package me.hdkz.seers.sign.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel.MapMode;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Util {

  public static String MD5(String message) throws NoSuchAlgorithmException {
    MessageDigest md = MessageDigest.getInstance("MD5");
    byte[] byteMsg = message.getBytes(StandardCharsets.UTF_8);
    byte[] byteDigest = md.digest(byteMsg);
    BigInteger bi = new BigInteger(1, byteDigest);
    return bi.toString(16).toUpperCase();
  }

  public static String MD5(File file) throws IOException, NoSuchAlgorithmException {
    MessageDigest md = MessageDigest.getInstance("MD5");
    FileInputStream fileInputStream = new FileInputStream(file);
    MappedByteBuffer byteBuffer = fileInputStream.getChannel()
        .map(MapMode.READ_ONLY, 0, file.length());
    md.update(byteBuffer);
    BigInteger bigInteger = new BigInteger(1, md.digest());
    return bigInteger.toString(16).toUpperCase();
  }

}
