package me.hekr.iotos.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import me.hekr.iotos.api.enums.DataCheckMode;
import me.hekr.iotos.api.enums.DataFormat;
import me.hekr.iotos.api.enums.DeviceLinkType;
import me.hekr.iotos.api.enums.DeviceType;
import me.hekr.iotos.api.enums.TransferType;

public class ProductDTO implements Serializable {
  private static final long serialVersionUID = 2147481103660105166L;
  protected String pk;
  protected boolean deleted;
  protected Date createdDate;
  protected Date updatedDate;
  protected DeviceType deviceType;
  protected String productSecret;
  protected List<Tag> tags;
  protected boolean dynamicRegister;
  protected boolean registerCheck;
  protected boolean loginCheck;
  protected boolean supportRemoteConfig;
  protected DataCheckMode dataCheckMode;
  private Integer quota;
  private Integer usedQuota;
  private DataFormat dataFormat;
  /** 联网方式 */
  private DeviceLinkType deviceLinkType;

  /** 数据传输类型 */
  private TransferType transferType;

  private String name;

  /** 型号 */
  private String model;
  /** 品牌 */
  private String brand;

  private String remark;
  private boolean open;
  /** 来自哪个pk的拷贝 */
  private String copyFromPk;

  public ProductDTO() {}

  public DataFormat getDataFormat() {
    return this.dataFormat == null ? DataFormat.KLINK : this.dataFormat;
  }

  public void setDataFormat(DataFormat dataFormat) {
    this.dataFormat = dataFormat;
  }

  public DataCheckMode getDataCheckMode() {
    return this.dataCheckMode == null ? DataCheckMode.STRICT : this.dataCheckMode;
  }

  public void setDataCheckMode(DataCheckMode dataCheckMode) {
    this.dataCheckMode = dataCheckMode;
  }

  public String getPk() {
    return this.pk;
  }

  public void setPk(String pk) {
    this.pk = pk;
  }

  public boolean isDeleted() {
    return this.deleted;
  }

  public void setDeleted(boolean deleted) {
    this.deleted = deleted;
  }

  public Date getCreatedDate() {
    return this.createdDate;
  }

  public void setCreatedDate(Date createdDate) {
    this.createdDate = createdDate;
  }

  public Date getUpdatedDate() {
    return this.updatedDate;
  }

  public void setUpdatedDate(Date updatedDate) {
    this.updatedDate = updatedDate;
  }

  public DeviceType getDeviceType() {
    return this.deviceType;
  }

  public void setDeviceType(DeviceType deviceType) {
    this.deviceType = deviceType;
  }

  public String getProductSecret() {
    return this.productSecret;
  }

  public void setProductSecret(String productSecret) {
    this.productSecret = productSecret;
  }

  public List<Tag> getTags() {
    return this.tags;
  }

  public void setTags(List<Tag> tags) {
    this.tags = tags;
  }

  public boolean isDynamicRegister() {
    return this.dynamicRegister;
  }

  public void setDynamicRegister(boolean dynamicRegister) {
    this.dynamicRegister = dynamicRegister;
  }

  public boolean isRegisterCheck() {
    return this.registerCheck;
  }

  public void setRegisterCheck(boolean registerCheck) {
    this.registerCheck = registerCheck;
  }

  public boolean isLoginCheck() {
    return this.loginCheck;
  }

  public void setLoginCheck(boolean loginCheck) {
    this.loginCheck = loginCheck;
  }

  public boolean isSupportRemoteConfig() {
    return this.supportRemoteConfig;
  }

  public void setSupportRemoteConfig(boolean supportRemoteConfig) {
    this.supportRemoteConfig = supportRemoteConfig;
  }

  public Integer getQuota() {
    return this.quota;
  }

  public void setQuota(Integer quota) {
    this.quota = quota;
  }

  public Integer getUsedQuota() {
    return this.usedQuota;
  }

  public void setUsedQuota(Integer usedQuota) {
    this.usedQuota = usedQuota;
  }

  @Override
  public String toString() {
    return "ProductDTO(pk="
        + this.getPk()
        + ", deleted="
        + this.isDeleted()
        + ", createdDate="
        + this.getCreatedDate()
        + ", updatedDate="
        + this.getUpdatedDate()
        + ", deviceType="
        + this.getDeviceType()
        + ", productSecret="
        + this.getProductSecret()
        + ", tags="
        + this.getTags()
        + ", dynamicRegister="
        + this.isDynamicRegister()
        + ", registerCheck="
        + this.isRegisterCheck()
        + ", loginCheck="
        + this.isLoginCheck()
        + ", supportRemoteConfig="
        + this.isSupportRemoteConfig()
        + ", dataCheckMode="
        + this.getDataCheckMode()
        + ", quota="
        + this.getQuota()
        + ", usedQuota="
        + this.getUsedQuota()
        + ", dataFormat="
        + this.getDataFormat()
        + ")";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    } else if (!(o instanceof ProductDTO)) {
      return false;
    } else {
      ProductDTO other = (ProductDTO) o;
      if (!other.canEqual(this)) {
        return false;
      } else {
        Object this$pk = this.getPk();
        Object other$pk = other.getPk();
        if (this$pk == null) {
          if (other$pk != null) {
            return false;
          }
        } else if (!this$pk.equals(other$pk)) {
          return false;
        }

        return true;
      }
    }
  }

  protected boolean canEqual(Object other) {
    return other instanceof ProductDTO;
  }
}
