/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import me.hekr.iotos.api.dto.DataValueChecker;
import me.hekr.iotos.api.dto.ModelParamValue;
import me.hekr.iotos.api.enums.CheckType;
import me.hekr.iotos.api.enums.DataType;

@JsonTypeName(value="RANGE")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataValueRangeChecker
implements DataValueChecker {
    private ModelParamValue<? extends Number> max;
    private ModelParamValue<? extends Number> min;

    @Override
    public CheckType getType() {
        return CheckType.RANGE;
    }

    @Override
    public boolean isValid(DataType dataType, Object value) {
        boolean isTypeValid;
        if (!DataType.isValid(dataType, value)) {
            return false;
        }
        DataType datatype = DataType.fromValue(value);
        boolean bl = isTypeValid = datatype == DataType.INT || datatype == DataType.FLOAT;
        if (!isTypeValid) {
            return false;
        }
        double dVal = ((Number)value).doubleValue();
        return dVal >= this.min.getValue().doubleValue() && dVal <= this.max.getValue().doubleValue();
    }

    @Override
    public boolean canConvertTo(DataType dataType) {
        return true;
    }

    @Override
    public boolean valid(DataType dataType) {
        return this.max != null && this.min != null && this.max.getValue() != null && this.min.getValue() != null;
    }

    public void setMax(ModelParamValue<? extends Number> max) {
        this.max = max;
    }

    public void setMin(ModelParamValue<? extends Number> min) {
        this.min = min;
    }

    public ModelParamValue<? extends Number> getMax() {
        return this.max;
    }

    public ModelParamValue<? extends Number> getMin() {
        return this.min;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataValueRangeChecker)) {
            return false;
        }
        DataValueRangeChecker other = (DataValueRangeChecker)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ModelParamValue<? extends Number> this$max = this.getMax();
        ModelParamValue<? extends Number> other$max = other.getMax();
        if (this$max == null ? other$max != null : !this$max.equals(other$max)) {
            return false;
        }
        ModelParamValue<? extends Number> this$min = this.getMin();
        ModelParamValue<? extends Number> other$min = other.getMin();
        return !(this$min == null ? other$min != null : !this$min.equals(other$min));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataValueRangeChecker;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModelParamValue<? extends Number> $max = this.getMax();
        result = result * 59 + ($max == null ? 43 : $max.hashCode());
        ModelParamValue<? extends Number> $min = this.getMin();
        result = result * 59 + ($min == null ? 43 : $min.hashCode());
        return result;
    }

    public String toString() {
        return "DataValueRangeChecker(max=" + this.getMax() + ", min=" + this.getMin() + ")";
    }
}

