/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.hekr.iotos.api.enums.TransferType;

public enum DeviceLinkType {
    WIFI("Wi-Fi", TransferType.MQTT, TransferType.HTTP, TransferType.TCP, TransferType.UDP, TransferType.OTHER),
    CELLUAR("2/3/4/5G", TransferType.MQTT, TransferType.HTTP, TransferType.TCP, TransferType.UDP, TransferType.OTHER),
    NBIOT("NB-IoT", TransferType.COAP, TransferType.LWM2M, TransferType.NB_OPERATOR),
    ETH("\u4ee5\u592a\u7f51(\u6709\u7ebf) ", TransferType.MQTT, TransferType.HTTP, TransferType.TCP, TransferType.UDP, TransferType.OTHER),
    OTHER("\u5176\u4ed6", TransferType.MQTT, TransferType.HTTP, TransferType.TCP, TransferType.UDP, TransferType.OTHER),
    LORA("LoRa", TransferType.LORA, new TransferType[0]);

    private final String desc;
    private final List<TransferType> transferTypes;

    private DeviceLinkType(String desc, TransferType transferType, TransferType ... transferTypes) {
        this.desc = desc;
        ArrayList<TransferType> transferTypeList = new ArrayList<TransferType>();
        transferTypeList.add(transferType);
        if (transferTypes != null) {
            transferTypeList.addAll(Arrays.asList(transferTypes));
        }
        this.transferTypes = transferTypeList;
    }

    public boolean hasTransferType(TransferType transferType) {
        if (transferType == null) {
            return false;
        }
        return this.transferTypes.contains((Object)transferType);
    }

    public String getDesc() {
        return this.desc;
    }

    public List<TransferType> getTransferTypes() {
        return this.transferTypes;
    }
}

