/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum UpgradeType {
    MODULE("module"),
    MCU("mcu"),
    CONFIG("config");

    public static final Map<String, UpgradeType> MAP;
    private final String type;

    private UpgradeType(String type) {
        this.type = type;
    }

    public static UpgradeType of(String type) {
        return MAP.get(type);
    }

    public String getType() {
        return this.type;
    }

    static {
        MAP = Arrays.stream(UpgradeType.values()).collect(Collectors.toMap(t -> t.type, Function.identity()));
    }
}

