/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hekr.iotos.api.dto.CloudSendMsgDTO;
import me.hekr.iotos.api.dto.ConsoleProductReq;
import me.hekr.iotos.api.dto.ConsoleUpdateProductReq;
import me.hekr.iotos.api.dto.DataShapeScriptDTO;
import me.hekr.iotos.api.dto.DelTopoResp;
import me.hekr.iotos.api.dto.DevIdListReq;
import me.hekr.iotos.api.dto.DeviceAddReq;
import me.hekr.iotos.api.dto.DeviceAggPacketResp;
import me.hekr.iotos.api.dto.DeviceApiDTO;
import me.hekr.iotos.api.dto.DeviceDTO;
import me.hekr.iotos.api.dto.DevicePacketMeasurement;
import me.hekr.iotos.api.dto.DevicePacketResp;
import me.hekr.iotos.api.dto.DeviceStatusRes;
import me.hekr.iotos.api.dto.DeviceUpdateNameReq;
import me.hekr.iotos.api.dto.DeviceUpgradeReq;
import me.hekr.iotos.api.dto.LoginRsp;
import me.hekr.iotos.api.dto.ModelCmdDTO;
import me.hekr.iotos.api.dto.ModelParamDTO;
import me.hekr.iotos.api.dto.ModelProtocolDTO;
import me.hekr.iotos.api.dto.ParamValue;
import me.hekr.iotos.api.dto.ParamValueQuery;
import me.hekr.iotos.api.dto.ProductDTO;
import me.hekr.iotos.api.dto.Snapshot;
import me.hekr.iotos.api.dto.UpgradeTaskDTO;
import me.hekr.iotos.api.dto.UploadResult;
import me.hekr.iotos.api.dto.klink.AddTopoResp;
import me.hekr.iotos.api.dto.klink.BatchAddTopoResp;
import me.hekr.iotos.api.dto.klink.KlinkResp;
import me.hekr.iotos.api.dto.klink.ModelData;
import me.hekr.iotos.api.dto.klink.TopoSub;
import me.hekr.iotos.api.enums.DeviceType;
import me.hekr.iotos.api.util.Pagec;
import okhttp3.MultipartBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface RetrofitIotService {
    public static final Logger log = LoggerFactory.getLogger(RetrofitIotService.class);

    @GET(value="product")
    public Call<Pagec<ProductDTO>> getProduct(@Query(value="page") int var1, @Query(value="size") int var2);

    @GET(value="admin/productList")
    public Call<Pagec<ProductDTO>> getAdminProduct(@Query(value="page") int var1, @Query(value="size") int var2);

    @GET(value="admin/dataShapeScript/{pk}")
    public Call<DataShapeScriptDTO> getAdminDataShape(@Path(value="pk") String var1);

    @PUT(value="admin/dataShapeScript/{pk}")
    public Call<DataShapeScriptDTO> adminCreateOrUpdateDataShape(@Path(value="pk") String var1, @Body DataShapeScriptDTO var2);

    @GET(value="admin/deviceInfo/{pk}/{devId}")
    public Call<DeviceApiDTO> getAdminDevice(@Path(value="pk") String var1, @Path(value="devId") String var2);

    @POST(value="admin/addDevice")
    public Call<DeviceApiDTO> adminAddDevice(@Body DeviceAddReq var1);

    @GET(value="admin/deviceStat/agglog/{pk}/{devId}")
    public Call<DeviceAggPacketResp> adminGetDeviceStatAggLog(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="startTime") Long var3, @Query(value="endTime") Long var4, @Query(value="key") String var5, @Query(value="span") String var6);

    @GET(value="admin/deviceStat/kvlog/{pk}/{devId}")
    public Call<List<DevicePacketMeasurement>> adminGetDeviceStatVersion(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="startTime") long var3, @Query(value="endTime") long var5, @Query(value="key") String var7);

    @Multipart
    @POST(value="admin/addUpgradeFile")
    public Call<UploadResult> adminAddUpgradeFile(@Part MultipartBody.Part var1);

    @POST(value="admin/addUpgrade")
    public Call<Void> adminAddUpgrade(@Body DeviceUpgradeReq var1);

    @DELETE(value="admin/delete/{pk}/{id}")
    public Call<Void> adminDeleteUpgrade(@Path(value="pk") String var1, @Path(value="id") String var2);

    @POST(value="admin/disable/{pk}/{id}")
    public Call<Void> adminDisableUpgrade(@Path(value="pk") String var1, @Path(value="id") String var2);

    @POST(value="admin/enable/{pk}/{id}")
    public Call<Void> adminEnableUpgrade(@Path(value="pk") String var1, @Path(value="id") String var2);

    @GET(value="admin/upgradeList")
    public Call<Pagec<UpgradeTaskDTO>> adminGetUpgradeList(@Query(value="pk") List<String> var1, @Query(value="type") String var2, @Query(value="page") Integer var3, @Query(value="size") Integer var4);

    @GET(value="admin/productList/pks")
    public Call<List<ProductDTO>> getAdminProductInfoListByPks(@Query(value="pks") Set<String> var1);

    @DELETE(value="admin/product/{pk}")
    public Call<Void> adminDeleteProduct(@Path(value="pk") String var1);

    @GET(value="admin/model/protocolByPks")
    public Call<List<ModelProtocolDTO>> getAdminModelByPks(@Query(value="pks") Set<String> var1);

    @POST(value="product")
    public Call<ProductDTO> createProduct(@Body ConsoleProductReq var1);

    @PUT(value="product")
    public Call<ProductDTO> editProduct(@Body ConsoleUpdateProductReq var1);

    @GET(value="model/protocol/{pk}")
    public Call<ModelProtocolDTO> getProtocol(@Path(value="pk") String var1);

    @GET(value="admin/getDevicePackage/{pk}/{devId}")
    public Call<List<DevicePacketResp>> adminGetDevicePackage(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="startTime") Long var3, @Query(value="endTime") Long var4, @Query(value="action") String var5, @Query(value="page") int var6, @Query(value="size") int var7);

    @GET(value="admin/getSnapshot")
    public Call<Snapshot> adminGetDeviceSnapshot(@Query(value="pk") String var1, @Query(value="devId") String var2);

    @GET(value="admin/topo")
    public Call<Pagec<DeviceDTO>> adminGetDeviceTopo(@Query(value="pk") String var1, @Query(value="devId") String var2, @Query(value="page") int var3, @Query(value="size") int var4);

    @PUT(value="admin/addTopo/{pk}/{devId}")
    public Call<AddTopoResp> adminAddTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body DeviceDTO var3);

    @HTTP(method="DELETE", path="admin/delTopo/{pk}/{devId}", hasBody=true)
    public Call<DelTopoResp> adminDelTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body DeviceDTO var3);

    @Multipart
    @PUT(value="admin/batchAddTopo/{pk}/{devId}")
    public Call<BatchAddTopoResp> adminBatchAddTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="overwrite") boolean var3, @Part MultipartBody.Part var4);

    @GET(value="admin/model/protocol/{pk}")
    public Call<ModelProtocolDTO> getAdminProtocol(@Path(value="pk") String var1);

    @POST(value="admin/model/protocol/{pk}")
    public Call<ModelProtocolDTO> adminCreateModel(@Path(value="pk") String var1, @Body ModelProtocolDTO var2);

    @POST(value="admin/model/protocol/{pk}/param")
    public Call<ModelProtocolDTO> adminAddModelParam(@Path(value="pk") String var1, @Body ModelParamDTO var2);

    @PUT(value="admin/model/protocol/{pk}/param")
    public Call<ModelProtocolDTO> adminUpdateModelParam(@Path(value="pk") String var1, @Body ModelParamDTO var2);

    @DELETE(value="admin/model/protocol/{pk}/param/{param}")
    public Call<ModelProtocolDTO> adminDeleteModelParam(@Path(value="pk") String var1, @Path(value="param") String var2);

    @POST(value="admin/model/protocol/{pk}/cmd")
    public Call<ModelProtocolDTO> adminAddModelCmd(@Path(value="pk") String var1, @Body ModelCmdDTO var2);

    @PUT(value="admin/model/protocol/{pk}/cmd")
    public Call<ModelProtocolDTO> adminUpdateModelCmd(@Path(value="pk") String var1, @Body ModelCmdDTO var2);

    @DELETE(value="admin/model/protocol/{pk}/cmd/{cmd}")
    public Call<ModelProtocolDTO> adminDeleteModelCmd(@Path(value="pk") String var1, @Path(value="cmd") String var2);

    @POST(value="api/device/addDevice")
    public Call<DeviceApiDTO> createDevice(@Body DeviceAddReq var1);

    @GET(value="api/device/getBatchDevices/{pk}/{batchName}")
    public Call<List<DeviceApiDTO>> getBatchDevices(@Path(value="pk") String var1, @Path(value="batchName") String var2);

    @PUT(value="api/device/updateName")
    public Call<Void> updateName(@Body DeviceUpdateNameReq var1);

    @GET(value="api/device/deviceInfo/{pk}/{devId}")
    public Call<DeviceApiDTO> getDevice(@Path(value="pk") String var1, @Path(value="devId") String var2);

    @POST(value="api/device/getDeviceStatus")
    public Call<List<DeviceStatusRes>> getDeviceStatus(@Body DevIdListReq var1);

    @POST(value="admin/cloudSend/{pk}/{devId}")
    public Call<KlinkResp> adminDeviceCloudSend(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body ModelData var3);

    @POST(value="api/deviceStat/kvlog/{pk}/{devId}")
    public Call<List<ParamValue>> getParamValue(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body ParamValueQuery var3);

    @GET(value="api/user/getLoginToken")
    public Call<LoginRsp> getLoginToken();

    @POST(value="api/device/addDevice")
    public Call<DeviceApiDTO> addDevice(@Body DeviceAddReq var1);

    @POST(value="api/device/batchAddDevices")
    public Call<Map<String, Object>> batchAddDevices(@Body DevIdListReq var1);

    @GET(value="api/device/getDeviceList")
    public Call<Pagec<DeviceApiDTO>> getDeviceList(@Query(value="pk") String var1, @Query(value="keyword") String var2, @Query(value="page") int var3, @Query(value="deviceType") DeviceType var4, @Query(value="online") Boolean var5, @Query(value="size") int var6);

    @GET(value="admin/getDeviceList")
    public Call<Pagec<DeviceApiDTO>> getAdminDeviceList(@Query(value="pk") String var1, @Query(value="keyword") String var2, @Query(value="page") int var3, @Query(value="online") Boolean var4, @Query(value="size") int var5);

    @GET(value="api/device/deviceInfo/{pk}/{devId}")
    public Call<DeviceApiDTO> deviceInfo(@Path(value="pk") String var1, @Path(value="devId") String var2);

    @GET(value="api/device/getSnapshot")
    public Call<Snapshot> getDeviceSnapshot(@Query(value="pk") String var1, @Query(value="devId") String var2);

    @DELETE(value="api/device/delDevice/{pk}/{devId}")
    public Call<Void> delDevice(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="delSnapshot") boolean var3);

    @GET(value="api/device/getDeviceHistoryData/{pk}/{devId}")
    public Call<List<DevicePacketResp>> getDeviceHistoryData(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="startTime") Long var3, @Query(value="endTime") Long var4, @Query(value="action") String var5, @Query(value="cmd") String var6, @Query(value="page") int var7, @Query(value="size") int var8);

    @POST(value="api/device/cloudSend/{pk}/{devId}")
    public Call<KlinkResp> deviceCloudSend(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body ModelData var3);

    @GET(value="api/device/cloudSendMsgInfo/{messageId}")
    public Call<CloudSendMsgDTO> cloudSendMsgInfo(@Path(value="messageId") String var1);

    @GET(value="api/device/cloudSendMsgList")
    public Call<Pagec<CloudSendMsgDTO>> cloudSendMsgList(@Query(value="page") Integer var1, @Query(value="size") Integer var2, @Query(value="pk") String var3, @Query(value="devId") String var4, @Query(value="startTime") Long var5, @Query(value="endTime") Long var6);

    @PUT(value="api/device/addTopo/{pk}/{devId}")
    public Call<AddTopoResp> addTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body TopoSub var3);

    @PUT(value="api/device/delTopo/{pk}/{devId}")
    public Call<DelTopoResp> delTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body TopoSub var3);

    @GET(value="api/deviceStat/agglog/{pk}/{devId}")
    public Call<DeviceAggPacketResp> getDeviceAggData(@Path(value="pk") String var1, @Path(value="devId") String var2, @QueryMap Map<String, Object> var3);

    @GET(value="cat/system")
    public Call<Object> getSystem();

    @GET(value="cat/product")
    public Call<Object> getCatProduct();
}

