/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import me.hekr.iotos.api.dto.DataValueChecker;
import me.hekr.iotos.api.dto.ModelParamValue;
import me.hekr.iotos.api.enums.CheckType;
import me.hekr.iotos.api.enums.DataType;

@JsonTypeName(value="ENUM")
public class DataValueEnumChecker
implements DataValueChecker {
    private List<ModelParamValue<Object>> values;

    @Override
    @JsonIgnore
    public boolean isValid(DataType dataType, Object value) {
        ModelParamValue<Object> v;
        DataType valueDataType = DataType.fromValue(value);
        if (!DataType.isValid(dataType, value)) {
            return false;
        }
        Iterator<ModelParamValue<Object>> var4 = this.values.iterator();
        do {
            if (var4.hasNext()) continue;
            return false;
        } while (!valueDataType.isEq((v = var4.next()).getValue(), value));
        return true;
    }

    @Override
    @JsonIgnore
    public boolean canConvertTo(DataType dataType) {
        ArrayList result = new ArrayList(this.values.size());
        for (ModelParamValue<Object> o : this.values) {
            try {
                Object v = dataType.convert(o.getValue());
                result.add(new ModelParamValue(v, o.getDesc()));
            }
            catch (Exception var6) {
                return false;
            }
        }
        this.values.clear();
        this.values.addAll(result);
        return true;
    }

    @Override
    public boolean valid(DataType dataType) {
        return this.values == null ? false : this.values.stream().allMatch(v -> {
            if (v != null && v.getValue() != null) {
                if (dataType == DataType.FLOAT && DataType.fromValue(v.getValue()) == DataType.INT) {
                    return true;
                }
                return DataType.fromValue(v.getValue()) == dataType;
            }
            return false;
        });
    }

    @Override
    public CheckType getType() {
        return CheckType.ENUM;
    }

    public String toString() {
        String str = this.values == null ? "[]" : "[" + this.values.stream().map(m -> m.getValue() + ":" + m.getDesc()).collect(Collectors.joining(", ")) + "]";
        return "enum check, enum values:" + str;
    }

    public List<ModelParamValue<Object>> getValues() {
        return this.values;
    }

    public void setValues(List<ModelParamValue<Object>> values) {
        this.values = values;
    }
}

