/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import me.hekr.iotos.api.dto.DataValueChecker;
import me.hekr.iotos.api.dto.DataValueEnumChecker;
import me.hekr.iotos.api.dto.DataValueLengthChecker;
import me.hekr.iotos.api.dto.DataValueNoneChecker;
import me.hekr.iotos.api.dto.DataValueRangeChecker;

public enum DataType {
    STRING(new Class[]{DataValueNoneChecker.class, DataValueLengthChecker.class, DataValueEnumChecker.class}){

        public String convert(Object obj) {
            return String.valueOf(obj);
        }
    }
    ,
    INT(new Class[]{DataValueNoneChecker.class, DataValueRangeChecker.class, DataValueEnumChecker.class}){

        public Long convert(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            throw new NumberFormatException(obj + " is not number");
        }
    }
    ,
    FLOAT(new Class[]{DataValueNoneChecker.class, DataValueRangeChecker.class, DataValueEnumChecker.class}){

        public Double convert(Object obj) {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            throw new NumberFormatException(obj + " is not number");
        }
    };

    private Set<Class<? extends DataValueChecker>> supportCheckTypes;

    private DataType(Class<? extends DataValueChecker> ... checkTypes) {
        this.supportCheckTypes = checkTypes != null && checkTypes.length != 0 ? Arrays.stream(checkTypes).collect(Collectors.toSet()) : Collections.emptySet();
    }

    public static DataType fromValue(Object value) {
        if (!(value instanceof Double) && !(value instanceof Float)) {
            if (value instanceof Number) {
                return INT;
            }
            return value instanceof String ? STRING : null;
        }
        return FLOAT;
    }

    public static boolean isValid(DataType dataType, Object value) {
        if (dataType == null) {
            return false;
        }
        DataType type = DataType.fromValue(value);
        if (type == null) {
            return false;
        }
        return dataType == type || type == INT && dataType == FLOAT;
    }

    public abstract <T> T convert(Object var1);

    public boolean isEq(Object v1, Object v2) {
        try {
            return this.convert(v1).equals(this.convert(v2));
        }
        catch (Exception var4) {
            return false;
        }
    }

    public boolean isSupport(DataValueChecker checkType) {
        return checkType == null ? false : this.supportCheckTypes.contains(checkType.getClass());
    }

    public String getSupportCheckTypesDesc() throws IllegalAccessException, InstantiationException {
        if (this.supportCheckTypes == null) {
            return "";
        }
        StringBuilder desc = new StringBuilder();
        for (Class<? extends DataValueChecker> clazz : this.supportCheckTypes) {
            desc.append(clazz.newInstance().getType().getType()).append(",");
        }
        return desc.length() == 0 ? desc.toString() : desc.deleteCharAt(desc.length() - 1).toString();
    }
}

