/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.hekr.iotos.api.enums.DataFormat;

public enum TransferType {
    MQTT("mqtt", DataFormat.KLINK, DataFormat.CUSTOM),
    HTTP("http", DataFormat.KLINK, new DataFormat[0]),
    TCP("tcp", DataFormat.KLINK, DataFormat.CUSTOM),
    UDP("udp", DataFormat.KLINK, DataFormat.CUSTOM),
    COAP("CoAP", DataFormat.KLINK, DataFormat.CUSTOM),
    LWM2M("LwM2M", DataFormat.KLINK, DataFormat.CUSTOM),
    NB_OPERATOR("nb_operator", DataFormat.KLINK, DataFormat.CUSTOM),
    OTHER("\u5176\u4ed6", DataFormat.KLINK, DataFormat.CUSTOM),
    LORA("LoRa", DataFormat.CUSTOM, new DataFormat[0]);

    private final String desc;
    private final List<DataFormat> dataFormats;

    private TransferType(String desc, DataFormat dataFormat, DataFormat ... dataFormats) {
        this.desc = desc;
        ArrayList<DataFormat> transferTypeList = new ArrayList<DataFormat>();
        transferTypeList.add(dataFormat);
        if (dataFormats != null) {
            transferTypeList.addAll(Arrays.asList(dataFormats));
        }
        this.dataFormats = transferTypeList;
    }

    public boolean hasDataFormat(DataFormat dataFormat) {
        if (dataFormat == null) {
            return false;
        }
        return this.dataFormats.contains((Object)dataFormat);
    }

    public String getDesc() {
        return this.desc;
    }

    public List<DataFormat> getDataFormats() {
        return this.dataFormats;
    }
}

