/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.service;

import java.util.List;
import java.util.Map;
import me.hekr.iotos.api.dto.CloudSendMsgDTO;
import me.hekr.iotos.api.dto.DelTopoResp;
import me.hekr.iotos.api.dto.DevIdListReq;
import me.hekr.iotos.api.dto.DeviceAddReq;
import me.hekr.iotos.api.dto.DeviceAggPacketResp;
import me.hekr.iotos.api.dto.DeviceApiDTO;
import me.hekr.iotos.api.dto.DevicePacketResp;
import me.hekr.iotos.api.dto.DeviceStatusRes;
import me.hekr.iotos.api.dto.DeviceUpdateNameReq;
import me.hekr.iotos.api.dto.LoginRsp;
import me.hekr.iotos.api.dto.ModelProtocolDTO;
import me.hekr.iotos.api.dto.ParamValue;
import me.hekr.iotos.api.dto.ParamValueQuery;
import me.hekr.iotos.api.dto.ProductDTO;
import me.hekr.iotos.api.dto.Snapshot;
import me.hekr.iotos.api.dto.klink.AddTopoResp;
import me.hekr.iotos.api.dto.klink.KlinkResp;
import me.hekr.iotos.api.dto.klink.ModelData;
import me.hekr.iotos.api.dto.klink.TopoSub;
import me.hekr.iotos.api.enums.DeviceType;
import me.hekr.iotos.api.util.Pagec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

public interface RetrofitIotService {
    public static final Logger log = LoggerFactory.getLogger(RetrofitIotService.class);

    @GET(value="product")
    public Call<Pagec<ProductDTO>> getProduct(@Query(value="page") int var1, @Query(value="size") int var2);

    @GET(value="model/protocol/{pk}")
    public Call<ModelProtocolDTO> getProtocol(@Path(value="pk") String var1);

    @POST(value="api/device/addDevice")
    public Call<DeviceApiDTO> createDevice(@Body DeviceAddReq var1);

    @GET(value="api/device/getBatchDevices/{pk}/{batchName}")
    public Call<List<DeviceApiDTO>> getBatchDevices(@Path(value="pk") String var1, @Path(value="batchName") String var2);

    @PUT(value="api/device/updateName")
    public Call<Void> updateName(@Body DeviceUpdateNameReq var1);

    @GET(value="api/device/deviceInfo/{pk}/{devId}")
    public Call<DeviceApiDTO> getDevice(@Path(value="pk") String var1, @Path(value="devId") String var2);

    @POST(value="api/device/getDeviceStatus")
    public Call<List<DeviceStatusRes>> getDeviceStatus(@Body DevIdListReq var1);

    @POST(value="api/deviceStat/kvlog/{pk}/{devId}")
    public Call<List<ParamValue>> getParamValue(@Body ParamValueQuery var1);

    @GET(value="api/user/getLoginToken")
    public Call<LoginRsp> getLoginToken();

    @POST(value="api/device/addDevice")
    public Call<DeviceApiDTO> addDevice(@Body DeviceAddReq var1);

    @POST(value="api/device/batchAddDevices")
    public Call<Map<String, Object>> batchAddDevices(@Body DevIdListReq var1);

    @GET(value="api/device/getDeviceList")
    public Call<Pagec<DeviceApiDTO>> getDeviceList(@Query(value="pk") String var1, @Query(value="keyword") String var2, @Query(value="page") int var3, @Query(value="deviceType") DeviceType var4, @Query(value="online") Boolean var5, @Query(value="size") int var6);

    @GET(value="api/device/deviceInfo/{pk}/{devId}")
    public Call<DeviceApiDTO> deviceInfo(@Path(value="pk") String var1, @Path(value="devId") String var2);

    @GET(value="api/device/getSnapshot")
    public Call<Snapshot> getDeviceSnapshot(@Query(value="pk") String var1, @Query(value="devId") String var2);

    @DELETE(value="api/device/delDevice/{pk}/{devId}")
    public Call<Void> delDevice(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="delSnapshot") boolean var3);

    @GET(value="api/device/getDeviceHistoryData/{pk}/{devId}")
    public Call<List<DevicePacketResp>> getDeviceHistoryData(@Path(value="pk") String var1, @Path(value="devId") String var2, @Query(value="startTime") Long var3, @Query(value="endTime") Long var4, @Query(value="action") String var5, @Query(value="cmd") String var6, @Query(value="page") int var7, @Query(value="size") int var8);

    @POST(value="api/device/cloudSend/{pk}/{devId}")
    public Call<KlinkResp> deviceCloudSend(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body ModelData var3);

    @GET(value="api/device/cloudSendMsgInfo/{messageId}")
    public Call<CloudSendMsgDTO> cloudSendMsgInfo(@Path(value="messageId") String var1);

    @GET(value="api/device/cloudSendMsgList")
    public Call<Pagec<CloudSendMsgDTO>> cloudSendMsgList(@Query(value="page") Integer var1, @Query(value="size") Integer var2, @Query(value="pk") String var3, @Query(value="devId") String var4, @Query(value="startTime") Long var5, @Query(value="endTime") Long var6);

    @PUT(value="api/device/addTopo/{pk}/{devId}")
    public Call<AddTopoResp> addTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body TopoSub var3);

    @PUT(value="api/device/delTopo/{pk}/{devId}")
    public Call<DelTopoResp> delTopo(@Path(value="pk") String var1, @Path(value="devId") String var2, @Body TopoSub var3);

    @GET(value="api/deviceStat/agglog/{pk}/{devId}")
    public Call<DeviceAggPacketResp> getDeviceAggData(@Path(value="pk") String var1, @Path(value="devId") String var2, @QueryMap Map<String, Object> var3);
}

