package me.hekr.iotos.api.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;
import me.hekr.iotos.api.enums.DataCheckMode;
import me.hekr.iotos.api.enums.DataFormat;
import me.hekr.iotos.api.enums.DeviceLinkType;
import me.hekr.iotos.api.enums.DeviceType;
import me.hekr.iotos.api.enums.TransferType;

@Data
public class ProductDTO implements Serializable {
  private static final long serialVersionUID = 2147481103660105166L;
  protected String pk;
  protected boolean deleted;
  protected Date createdDate;
  protected Date updatedDate;
  protected DeviceType deviceType;
  protected String productSecret;
  protected List<Tag> tags;
  protected boolean dynamicRegister;
  protected boolean registerCheck;
  protected boolean loginCheck;
  protected boolean supportRemoteConfig;
  protected DataCheckMode dataCheckMode;
  private Integer quota;
  private Integer usedQuota;
  private DataFormat dataFormat;
  /** 联网方式 */
  private DeviceLinkType deviceLinkType;

  /** 数据传输类型 */
  private TransferType transferType;

  private String name;

  /** 型号 */
  private String model;
  /** 品牌 */
  private String brand;

  private String remark;
  private boolean open;
  /** 来自哪个pk的拷贝 */
  private String copyFromPk;

  public DataFormat getDataFormat() {
    return this.dataFormat == null ? DataFormat.KLINK : this.dataFormat;
  }

  public DataCheckMode getDataCheckMode() {
    return this.dataCheckMode == null ? DataCheckMode.STRICT : this.dataCheckMode;
  }
}
