/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import me.hekr.iotos.api.IotErrorResponse;
import me.hekr.iotos.api.dto.AggDataQuery;
import me.hekr.iotos.api.dto.CloudSendMsgDTO;
import me.hekr.iotos.api.dto.DelTopoResp;
import me.hekr.iotos.api.dto.DevIdListReq;
import me.hekr.iotos.api.dto.DeviceAddReq;
import me.hekr.iotos.api.dto.DeviceAggPacketResp;
import me.hekr.iotos.api.dto.DeviceApiDTO;
import me.hekr.iotos.api.dto.DevicePacketResp;
import me.hekr.iotos.api.dto.DeviceStatusRes;
import me.hekr.iotos.api.dto.DeviceUpdateNameReq;
import me.hekr.iotos.api.dto.LoginRsp;
import me.hekr.iotos.api.dto.ModelProtocolDTO;
import me.hekr.iotos.api.dto.ParamValue;
import me.hekr.iotos.api.dto.ParamValueQuery;
import me.hekr.iotos.api.dto.ProductDTO;
import me.hekr.iotos.api.dto.Snapshot;
import me.hekr.iotos.api.dto.klink.AddTopoResp;
import me.hekr.iotos.api.dto.klink.KlinkResp;
import me.hekr.iotos.api.dto.klink.ModelData;
import me.hekr.iotos.api.dto.klink.TopoSub;
import me.hekr.iotos.api.enums.DeviceType;
import me.hekr.iotos.api.enums.ErrorCode;
import me.hekr.iotos.api.exception.IotException;
import me.hekr.iotos.api.service.RetrofitIotService;
import me.hekr.iotos.api.util.JsonUtil;
import me.hekr.iotos.api.util.Pagec;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class IotClient {
    private static final Logger log = LoggerFactory.getLogger(IotClient.class);
    private static final String MAC_NAME = "HmacSHA1";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Retrofit retrofit;
    private final Builder builder;
    private final RetrofitIotService retrofitIotService;

    private IotClient(Builder builder) {
        this.builder = builder;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{builder.host, builder.ak, builder.as})) {
            throw new IllegalArgumentException("host, ak, as must not blank");
        }
        this.retrofit = this.createRetrofit();
        this.retrofitIotService = (RetrofitIotService)this.retrofit.create(RetrofitIotService.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static <T> T execute(Call<T> call) {
        Response response = call.execute();
        if (response.isSuccessful()) {
            int code;
            Object ret = response.body();
            if (ret instanceof KlinkResp && (code = ((KlinkResp)ret).getCode()) != 0) {
                throw new IotException(code, ((KlinkResp)ret).getDesc());
            }
            return (T)ret;
        }
        String msg = response.toString();
        if (response.errorBody() != null) {
            String respStr = response.errorBody().string();
            msg = msg + ", body: " + respStr;
            RetrofitIotService.log.error("\u8c03\u7528\u5931\u8d25\uff0c{}", (Object)msg);
            if (response.code() != 500) {
                IotErrorResponse result = JsonUtil.fromJson(respStr, IotErrorResponse.class);
                throw new IotException(result.getCode(), "IoTOS \u63a5\u53e3\u8c03\u7528\u5931\u8d25," + msg);
            }
        }
        throw new IotException(ErrorCode.UNDEFINED.getCode(), "IoTOS \u63a5\u53e3\u8c03\u7528\u5931\u8d25," + msg);
    }

    public <T> T register(Class<T> clazz) {
        return (T)this.retrofit.create(clazz);
    }

    public List<ProductDTO> getAllProducts() {
        return Pagec.getAll(0, 100, (page, size) -> this.getProduct(page, size).getContent());
    }

    public DeviceApiDTO createDevice(DeviceAddReq addReq) {
        return IotClient.execute(this.retrofitIotService.createDevice(addReq));
    }

    public DeviceApiDTO getDevice(String pk, String devId) {
        return IotClient.execute(this.retrofitIotService.getDevice(pk, devId));
    }

    public ModelProtocolDTO getProtocol(String pk) {
        return IotClient.execute(this.retrofitIotService.getProtocol(pk));
    }

    private Retrofit createRetrofit() {
        String baseUrl = this.builder.host;
        if (!baseUrl.startsWith("http")) {
            baseUrl = "http://" + baseUrl;
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        String prefix = StringUtils.stripEnd((String)new URL(baseUrl).getPath(), (String)"/");
        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        interceptor.setLevel(this.builder.level);
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)interceptor).addInterceptor(chain -> {
            String reqPath;
            String realPath = reqPath = chain.request().url().uri().getPath();
            if (StringUtils.isNotBlank((CharSequence)prefix)) {
                realPath = StringUtils.removeStart((String)reqPath, (String)prefix);
            }
            Request request = chain.request().newBuilder().addHeader("Authorization", this.getToken(realPath, this.builder.getAk(), this.builder.getAs())).addHeader("Content-Type", "application/json").build();
            if (log.isDebugEnabled()) {
                log.debug("request url: {}, request real path: {}", (Object)request.url().toString(), (Object)realPath);
            }
            return chain.proceed(request);
        }).callTimeout(10L, TimeUnit.SECONDS).connectTimeout(3L, TimeUnit.SECONDS).build();
        return new Retrofit.Builder().client(client).baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).build();
    }

    public String getToken(String path, String accessKey, String accessSecret) {
        String timestamp = String.valueOf(System.currentTimeMillis());
        String method = "SHA1";
        return this.assembleToken(path, timestamp, method, accessKey, accessSecret);
    }

    public byte[] hmacSHA1Encrypt(String encryptText, String encryptKey) throws Exception {
        byte[] data = encryptKey.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(data, MAC_NAME);
        Mac mac = Mac.getInstance(MAC_NAME);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes();
        return mac.doFinal(text);
    }

    public String parseByte2HexStr(byte[] buf) {
        if (null == buf) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString().toLowerCase();
    }

    public String assembleToken(String path, String timestamp, String method, String accessKey, String accessSecret) throws Exception {
        String encodePath = URLEncoder.encode(path, "UTF-8");
        String data = path + "\n" + timestamp + "\n" + method;
        String signature = this.parseByte2HexStr(this.hmacSHA1Encrypt(data, accessSecret));
        return "accessKey=" + accessKey + "&path=" + encodePath + "&timestamp=" + timestamp + "&method=" + method + "&sign=" + signature;
    }

    public LoginRsp getLoginToken() {
        return IotClient.execute(this.retrofitIotService.getLoginToken());
    }

    public Pagec<ProductDTO> getProduct(int page, int size) {
        return IotClient.execute(this.retrofitIotService.getProduct(page, size));
    }

    public List<DeviceApiDTO> getBatchDevices(String pk, String batchName) {
        return IotClient.execute(this.retrofitIotService.getBatchDevices(pk, batchName));
    }

    public void updateName(DeviceUpdateNameReq req) {
        IotClient.execute(this.retrofitIotService.updateName(req));
    }

    public List<DeviceStatusRes> getDeviceStatus(DevIdListReq req) {
        return IotClient.execute(this.retrofitIotService.getDeviceStatus(req));
    }

    public List<ParamValue> getParamValue(ParamValueQuery req) {
        return IotClient.execute(this.retrofitIotService.getParamValue(req.getPk(), req.getDevId(), req));
    }

    public DeviceApiDTO addDevice(DeviceAddReq reqDto) {
        return IotClient.execute(this.retrofitIotService.addDevice(reqDto));
    }

    public Map<String, Object> batchAddDevices(DevIdListReq devIdListReq) {
        return IotClient.execute(this.retrofitIotService.batchAddDevices(devIdListReq));
    }

    public Pagec<DeviceApiDTO> getDeviceList(String pk, String keyword, int page, DeviceType deviceType, Boolean online, int size) {
        return IotClient.execute(this.retrofitIotService.getDeviceList(pk, keyword, page, deviceType, online, size));
    }

    public DeviceApiDTO deviceInfo(String pk, String devId) {
        return IotClient.execute(this.retrofitIotService.deviceInfo(pk, devId));
    }

    public Snapshot getDeviceSnapshot(String pk, String devId) {
        return IotClient.execute(this.retrofitIotService.getDeviceSnapshot(pk, devId));
    }

    public void delDevice(String pk, String devId, boolean delSnapshot) {
        IotClient.execute(this.retrofitIotService.delDevice(pk, devId, delSnapshot));
    }

    public List<DevicePacketResp> getDeviceHistoryData(String pk, String devId, Long startTime, Long endTime, String action, String cmd, int page, int size) {
        return IotClient.execute(this.retrofitIotService.getDeviceHistoryData(pk, devId, startTime, endTime, action, cmd, page, size));
    }

    public KlinkResp deviceCloudSend(String pk, String devId, ModelData data) {
        return IotClient.execute(this.retrofitIotService.deviceCloudSend(pk, devId, data));
    }

    public CloudSendMsgDTO cloudSendMsgInfo(String messageId) {
        return IotClient.execute(this.retrofitIotService.cloudSendMsgInfo(messageId));
    }

    public Pagec<CloudSendMsgDTO> cloudSendMsgList(Integer page, Integer size, String pk, String devId, Long startTime, Long endTime) {
        return IotClient.execute(this.retrofitIotService.cloudSendMsgList(page, size, pk, devId, startTime, endTime));
    }

    public AddTopoResp addTopo(String pk, String devId, TopoSub sub) {
        return IotClient.execute(this.retrofitIotService.addTopo(pk, devId, sub));
    }

    public DelTopoResp delTopo(String pk, String devId, TopoSub sub) {
        return IotClient.execute(this.retrofitIotService.delTopo(pk, devId, sub));
    }

    public DeviceAggPacketResp getDeviceAggData(AggDataQuery query) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", query.getKey());
        params.put("span", query.getSpan());
        params.put("startTime", query.getStartTime());
        params.put("endTime", query.getEndTime());
        return IotClient.execute(this.retrofitIotService.getDeviceAggData(query.getPk(), query.getDevId(), params));
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_TRAILING_TOKENS, true);
    }

    public static class Builder {
        private String host;
        private String ak;
        private String as;
        private HttpLoggingInterceptor.Level level;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder ak(String ak) {
            this.ak = ak;
            return this;
        }

        public Builder as(String as) {
            this.as = as;
            return this;
        }

        public Builder level(HttpLoggingInterceptor.Level level) {
            this.level = level;
            return this;
        }

        public IotClient build() {
            if (this.level == null) {
                this.level = log.isDebugEnabled() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.NONE;
            }
            return new IotClient(this);
        }

        public String getHost() {
            return this.host;
        }

        public String getAk() {
            return this.ak;
        }

        public String getAs() {
            return this.as;
        }

        public HttpLoggingInterceptor.Level getLevel() {
            return this.level;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setAk(String ak) {
            this.ak = ak;
        }

        public void setAs(String as) {
            this.as = as;
        }

        public void setLevel(HttpLoggingInterceptor.Level level) {
            this.level = level;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$ak = this.getAk();
            String other$ak = other.getAk();
            if (this$ak == null ? other$ak != null : !this$ak.equals(other$ak)) {
                return false;
            }
            String this$as = this.getAs();
            String other$as = other.getAs();
            if (this$as == null ? other$as != null : !this$as.equals(other$as)) {
                return false;
            }
            HttpLoggingInterceptor.Level this$level = this.getLevel();
            HttpLoggingInterceptor.Level other$level = other.getLevel();
            return !(this$level == null ? other$level != null : !this$level.equals(other$level));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $ak = this.getAk();
            result = result * 59 + ($ak == null ? 43 : $ak.hashCode());
            String $as = this.getAs();
            result = result * 59 + ($as == null ? 43 : $as.hashCode());
            HttpLoggingInterceptor.Level $level = this.getLevel();
            result = result * 59 + ($level == null ? 43 : $level.hashCode());
            return result;
        }

        public String toString() {
            return "IotClient.Builder(host=" + this.getHost() + ", ak=" + this.getAk() + ", as=" + this.getAs() + ", level=" + this.getLevel() + ")";
        }
    }
}

