/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.api.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeName;
import me.hekr.iotos.api.dto.DataValueChecker;
import me.hekr.iotos.api.dto.ModelParamValue;
import me.hekr.iotos.api.enums.CheckType;
import me.hekr.iotos.api.enums.DataType;

@JsonTypeName(value="RANGE")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataValueRangeChecker
implements DataValueChecker {
    private ModelParamValue<? extends Number> max;
    private ModelParamValue<? extends Number> min;

    @Override
    public CheckType getType() {
        return CheckType.RANGE;
    }

    @Override
    public boolean isValid(DataType dataType, Object value) {
        boolean isTypeValid;
        if (!DataType.isValid(dataType, value)) {
            return false;
        }
        DataType datatype = DataType.fromValue(value);
        boolean bl = isTypeValid = datatype == DataType.INT || datatype == DataType.FLOAT;
        if (!isTypeValid) {
            return false;
        }
        double dVal = ((Number)value).doubleValue();
        return dVal >= this.min.getValue().doubleValue() && dVal <= this.max.getValue().doubleValue();
    }

    @Override
    public boolean canConvertTo(DataType dataType) {
        return true;
    }

    @Override
    public boolean valid(DataType dataType) {
        return this.max != null && this.min != null && this.max.getValue() != null && this.min.getValue() != null;
    }
}

