/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.sample;

import cn.hutool.core.thread.ThreadUtil;
import java.nio.charset.StandardCharsets;
import me.hekr.iotos.softgateway.network.common.DecodePacket;
import me.hekr.iotos.softgateway.network.common.client.EventListener;
import me.hekr.iotos.softgateway.network.common.client.EventListenerAdapter;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import me.hekr.iotos.softgateway.network.tcp.TcpClient;

public class TcpClientSample {
    private static final boolean sync = true;
    static PacketCoder<String> packetCoder = new PacketCoder<String>(){

        public byte[] encode(String s) {
            return s.getBytes(StandardCharsets.UTF_8);
        }

        public DecodePacket decode(byte[] bytes) {
            return DecodePacket.wrap((Object)new String(bytes, StandardCharsets.UTF_8), (int)bytes.length);
        }
    };

    public static void main(String[] args) {
        TcpClient client = new TcpClient("localhost", 1024);
        client.setEventListener((EventListener)new EventListenerAdapter());
        client.setPacketCoder(packetCoder);
        client.setMessageListener(ctx -> System.out.println("\u6536\u5230\u6765\u81ea\uff1a" + ctx.getAddress() + " \u7684\u6d88\u606f\uff1a" + (String)ctx.getMessage()));
        client.setSync(true);
        client.setTimeout(3000);
        client.setConnectTimeout(3000);
        client.setAutoReconnect(true);
        client.start();
        while (true) {
            String resp = (String)client.send((Object)"hello");
            System.out.println("\u6536\u5230\u56de\u590d: " + resp);
            ThreadUtil.sleep((long)1000L);
        }
    }
}

