/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.sample;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import me.hekr.iotos.softgateway.common.utils.JsonUtil;
import me.hekr.iotos.softgateway.network.http.HttpClient;
import me.hekr.iotos.softgateway.network.http.HttpPageResponse;
import me.hekr.iotos.softgateway.network.http.HttpRequest;
import me.hekr.iotos.softgateway.network.http.HttpRequestPageable;
import me.hekr.iotos.softgateway.network.http.HttpResponse;
import me.hekr.iotos.softgateway.network.http.HttpResponseChecker;
import me.hekr.iotos.softgateway.network.http.PageableResponse;
import me.hekr.iotos.softgateway.network.http.PageableResponseParser;
import me.hekr.iotos.softgateway.sample.Device;
import me.hekr.iotos.softgateway.sample.DeviceResponse;

public class HttpClientSample {
    public static void main(String[] args) {
        HttpClientSample.testRequestPageable();
        HttpClientSample.testRequestPageableItems();
        HttpClientSample.testChecker();
    }

    public static void testRequestPageable() {
        HttpClient client = HttpClient.newInstance((String)"http://localhost:8080/");
        client.setHttpResponseChecker(response -> response.getStatusCode() == 200);
        HttpRequestPageable<DeviceResponse> request = new HttpRequestPageable<DeviceResponse>(0, 10){

            public HttpRequest buildRequest(int curPage, int pageSize) {
                return HttpRequest.builder().addParam("curPage", (Object)curPage).addParam("pageSize", (Object)pageSize).build();
            }

            public boolean hasMore(DeviceResponse resp) {
                return resp.hasMore();
            }
        };
        PageableResponseParser parser = r -> HttpPageResponse.wrap((PageableResponse)((PageableResponse)JsonUtil.fromBytes((byte[])r.getBytes(), DeviceResponse.class)));
        List list = client.exec((HttpRequestPageable)request, parser, 0, 1);
        System.out.println(list);
    }

    public static void testRequestPageableItems() {
        HttpClient client = HttpClient.newInstance((String)"http://localhost:8080/");
        HttpRequestPageable<DeviceResponse> request = new HttpRequestPageable<DeviceResponse>(0, 10){

            public HttpRequest buildRequest(int curPage, int pageSize) {
                return HttpRequest.builder().path("items").addParam("curPage", (Object)curPage).addParam("pageSize", (Object)pageSize).build();
            }

            public boolean hasMore(DeviceResponse resp) {
                return resp.hasMore();
            }
        };
        PageableResponseParser parser = r -> {
            List devices = (List)JsonUtil.fromBytes((byte[])r.getBytes(), (TypeReference)new TypeReference<List<Device>>(){});
            return new HttpPageResponse((PageableResponse)new DeviceResponse(devices));
        };
        List list = client.exec((HttpRequestPageable)request, parser, 0, 1);
        System.out.println(list);
    }

    public static void testChecker() {
        HttpClient client = HttpClient.newInstance((String)"http://localhost:8080/");
        client.setHttpResponseChecker(new HttpResponseChecker(){

            public boolean isSuccess(HttpResponse response) {
                return response.getStatusCode() == 201;
            }

            public String desc() {
                return "\u4e0d\u662f201\uff01\uff01";
            }
        });
        client.exec(HttpRequest.builder().path("").build());
    }
}

