/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.sample;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import me.hekr.iotos.softgateway.network.common.DecodePacket;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import me.hekr.iotos.softgateway.network.tcp.TcpServer;
import me.hekr.iotos.softgateway.network.tcp.TcpServerConnectionContext;
import me.hekr.iotos.softgateway.network.tcp.listener.TcpMessageListener;

public class TcpServerSample {
    public static void main(String[] args) throws InterruptedException {
        TcpServer server = new TcpServer();
        server.bind(4201);
        server.setMessageListener((TcpMessageListener)new MyMessageListener((TcpServer<String>)server));
        server.setPackageCoder((PacketCoder)new MyPacketCoder());
        server.setHeartbeatTimeout(3000);
        server.start();
        new CountDownLatch(1).await();
    }

    static class MyMessageListener
    implements TcpMessageListener<String> {
        private final TcpServer<String> server;

        public MyMessageListener(TcpServer<String> server) {
            this.server = server;
        }

        public void onMessage(TcpServerConnectionContext<String> ctx) {
            System.out.println("\u6536\u5230\u6765\u81ea: " + ctx.getAddress() + " \u7684\u6d88\u606f\uff0c" + (String)ctx.getMessage());
            this.server.writeAndFlush(ctx, (Object)("\u56de\u590d:" + (String)ctx.getMessage()));
        }
    }

    static class MyPacketCoder
    implements PacketCoder<String> {
        MyPacketCoder() {
        }

        public byte[] encode(String s) {
            return s.getBytes(StandardCharsets.UTF_8);
        }

        public DecodePacket decode(byte[] bytes) {
            return DecodePacket.wrap((Object)new String(bytes), (int)bytes.length);
        }
    }
}

