/*
 * Decompiled with CFR 0.152.
 */
package me.hekr.iotos.softgateway.sample;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import me.hekr.iotos.softgateway.network.common.DecodePacket;
import me.hekr.iotos.softgateway.network.common.coder.PacketCoder;
import me.hekr.iotos.softgateway.network.udp.UdpServer;

public class UdpServerSample {
    static final int BIND_PORT = 4201;
    static final PacketCoder<String> PACKET_CODER = new PacketCoder<String>(){

        public byte[] encode(String s) {
            return s.getBytes(StandardCharsets.UTF_8);
        }

        public DecodePacket decode(byte[] bytes) {
            return DecodePacket.wrap((Object)new String(bytes, StandardCharsets.UTF_8), (int)bytes.length);
        }
    };

    public static void main(String[] args) throws InterruptedException {
        UdpServer server = new UdpServer(4201);
        server.setEnableNetLog(true);
        server.setPacketCoder(PACKET_CODER);
        server.setMessageListener(ctx -> {
            System.out.println("udp server \u6536\u5230\uff1a" + (String)ctx.getMessage());
            server.send(ctx, (Object)("server \u56de\u590d\u6536\u5230\uff1a" + (String)ctx.getMessage()));
        });
        server.start();
        new CountDownLatch(1).await();
    }
}

